//=============================================================================
// File: gnutconnectmsgbc.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"
#include "gnutcoord.h"
#include "gnut_util.h"

//=============================================================================
GnutConnectMsgBC::
GnutConnectMsgBC(GnutMsgParser::EGnutMsgType aType,
                 const GnutCoord& aCoord,
                 double aError)
: msg_type_(aType),
  coord_(aCoord),
  error_(aError),
  timeSent_(GnutUtil::now())
{ }
//=============================================================================
GnutConnectMsgBC::
GnutConnectMsgBC(const void* aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);
    memcpy(&msg_type_, ptr, sizeof(msg_type_));
    ptr += sizeof(msg_type_);

    // Sanity check that enables us to use a little shortcut.
    GNUT_ASSERT(sizeof(double) == sizeof(coord_.mX));

    const double* dblptr = reinterpret_cast<const double*>(ptr);

    const double x = *dblptr;
    dblptr++;

    const double y = *dblptr;
    dblptr++;
    
    const double height = *dblptr;
    dblptr++;

    coord_ = GnutCoord(x, y, height);

    error_ = *dblptr;
    dblptr++;
    
    timeSent_ = *dblptr;
}
//=============================================================================
GnutConnectMsgBC::
~GnutConnectMsgBC(void)
{ }
//=============================================================================
void 
GnutConnectMsgBC::
writeToPacket(void* aMem) const
{ 
    char* ptr = reinterpret_cast<char*>(aMem);

    memcpy(ptr, &msg_type_, sizeof(msg_type_));
    ptr += sizeof(msg_type_);

    memcpy(ptr, &coord_.mX, sizeof(coord_.mX));
    ptr += sizeof(coord_.mX);

    memcpy(ptr, &coord_.mY, sizeof(coord_.mY));
    ptr += sizeof(coord_.mY);

    memcpy(ptr, &coord_.mHeight, sizeof(coord_.mHeight));
    ptr += sizeof(coord_.mHeight);

    memcpy(ptr, &error_, sizeof(error_));
    ptr += sizeof(error_);

    memcpy(ptr, &timeSent_, sizeof(timeSent_));
}
//=============================================================================
size_t
GnutConnectMsgBC::
getSize(void) const
{
    return sizeof(msg_type_) + sizeof(coord_.mX) + sizeof(coord_.mY)
           + sizeof(coord_.mHeight) + sizeof(error_) + sizeof(timeSent_);
}
//=============================================================================

