//=============================================================================
// File: gnutconnectmsgbc.h
// Author: Andre Dufour
//
// Class type: abstract base
// Description: superclass for all gnutella connect messages (i.e. those 
//              exchanged while trying to establish a gnutella connection 
//              between peers).
//=============================================================================

#ifndef __GNUTCONNECTMSGBC_H__
#define __GNUTCONNECTMSGBC_H__

#include "ignutmsg.h"
#include "gnutmsgparser.h"
#include "gnut_types.h"
#include "gnutcoord.h"

//=============================================================================
class GnutConnectMsgBC : public IGnutMsg
{
protected:
    // = FOUNDATION

    // Build structure from user input
    GnutConnectMsgBC(GnutMsgParser::EGnutMsgType aType,
                     const GnutCoord& aCoord,
                     double aError);

    // Build structure from packet.
    GnutConnectMsgBC(const void* aMem);

    // Make class abstact
    virtual ~GnutConnectMsgBC(void) = 0;


    // = IGnutMsg

    virtual void writeToPacket(void* aMem) const;
    
public:
    // = ACCESS

    // Get length of the connectmsg header in packet.
    virtual size_t getSize(void) const;

    const GnutCoord& getCoordinates(void) const { return coord_; }

    double getError(void) const { return error_; }

    double getTimeSent(void) const { return timeSent_; }


private:
    // = DATA

    GnutMsgParser::EGnutMsgType             msg_type_;

    GnutCoord           coord_;
    // The Vivaldi coordinates of the node sending the message

    double              error_;
    // The error on the coordinates as estimated by the originating node

    double              timeSent_;
    // The time the message was first sent


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutConnectMsgBC(const GnutConnectMsgBC&);

    GnutConnectMsgBC& operator=(const GnutConnectMsgBC&);

};
//=============================================================================
#endif /* __GNUTCONNECTMSGBC_H__ */

