//=============================================================================
// File: gnuthierapp.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: Encapsulates the functionality of a coordinate in the Vivaldi
//              coordinate system. Coordinates have two euclidian dimensions
//              and a height component.
//=============================================================================

#ifndef __GNUTCOORD_H__
#define __GNUTCOORD_H__

#include <iostream>
#include <sstream>

class GnutCoord
{    
public:
friend class GnutBinaryMsgBC;
friend class GnutConnectMsgBC;


    // = FOUNDATION

    GnutCoord(void);
    // Construct a zero coordinate

    GnutCoord(double aLength);
    // Construct a coordinate of the specified length in a random direction.

    GnutCoord(double aLength, const GnutCoord& aDirection);
    // Construct a coordiante of the specified length in the direction of
    // the provided vector.

    virtual ~GnutCoord(void);

    // Default copy constructor and assignment operator enabled


    // = ACCESS

    double abs(void) const;
    // Calculate the modulus of the vector


    // = ACTION

    GnutCoord& operator+=(const GnutCoord& aRhs);
    GnutCoord& operator-=(const GnutCoord& aRhs);
    GnutCoord& operator*=(double aFactor);

    // = FRIENDS

    friend GnutCoord operator+(const GnutCoord& aLhs, const GnutCoord& aRhs);
    friend GnutCoord operator-(const GnutCoord& aLhs, const GnutCoord& aRhs);
    friend GnutCoord operator*(const GnutCoord& aCoord, double aFactor);
    friend GnutCoord operator*(double aFactor, const GnutCoord& aCoord);
    friend bool operator==(const GnutCoord& aLhs, const GnutCoord& aRhs);
    friend bool operator!=(const GnutCoord& aLhs, const GnutCoord& aRhs);
    friend std::ostream& operator<<(std::ostream& aOs, 
                                    const GnutCoord& aCoord);
    // Debugging: character output of the coordinate

private:
    // = FOUNDATION

    GnutCoord(double aX, double aY, double aHeight);
    // Construct a coordinate with the specified components.

    // = DATA

    double mX;
    double mY;
    double mHeight;
};
//=============================================================================
#endif /* __GNUTCOORD_H__ */

