#############################################################################
# File: gnuthierapp.tcl
# Author: Andre Dufour
#
#
#############################################################################

#Class GnutHierApp


#############################################################################
# Constructor
GnutHierApp instproc init { aVivaldi aAddr aActiveApp aBootServer aPeerSys aFreeLoader aUpeerCapable } {
    $self next $aAddr $aUpeerCapable
    $self instvar mPeerSys mBootServer mFreeLoader

    puts "Initializing hier app in tcl"

    if {$aFreeLoader != 0 && $aFreeLoader != 1} {
        # TODO: AD return an error
        puts "Invalid freeloader value ($aFreeLoader). Must be 0 or 1"
    }

    set mPeerSys $aPeerSys
    set mBootServer $aBootServer
    set mFreeLoader $aFreeLoader

    $self setActiveApplication $aVivaldi $aAddr $aActiveApp
}
#############################################################################
# Param aLeafInitUpeer is a bit of a hack. When an ultrapeer become a leaf
# further to leaf guidance from another ultrapeer, it is supposed to connect
# to that ultrapeer. If aLeafInitUpeer != -1, we are dealing with such a
# transition and the leaf is to be instructed to connect to the (ultra)peer
# with node number aLeafInitUpeer. If the value of the parameter is -1, this
# is some other transition.
GnutHierApp instproc setActiveApplication { aVivaldi aAddr aActiveApp {aLeafInitUpeer -1 } } {
    $self instvar mActiveApp mPeerSys mBootServer mFreeLoader

    if {[info exists mActiveApp] == 1} {
        puts "Tcl about to tell active app to cleanup."
        $mActiveApp cleanup
        puts "Tcl told active app to cleanup."
        #$mActiveApp destroy
        unset mActiveApp
    }

    if { [string compare $aActiveApp "LegacyActive"] == 0 } {
        set mActiveApp [new PeerApp/GnutellaApp $aVivaldi $aAddr 0 $self]
    } elseif {[string compare $aActiveApp "UltrapeerActive"] == 0 } {
        set mActiveApp [new PeerApp/GnutellaApp/Ultrapeer $aVivaldi $aAddr 0 $self]
    } elseif { [string compare $aActiveApp "LeafActive"] == 0 } {
        set mActiveApp [new PeerApp/GnutellaApp/Leaf $aVivaldi $aAddr 0 $self $aLeafInitUpeer]
    } else {
        puts "Error: invalid app type $aActiveApp"
        # TODO: AD return error
    }

    $self linkActiveApp $aActiveApp $mActiveApp

    $self use-smpbootserver $mBootServer

    # TODO: AD fix freeloader param later
    $self attach-peersys $mPeerSys 0
}
#############################################################################

