//=============================================================================
// File: gnutleafokmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a leafok message.
//=============================================================================

#ifndef __GNUTLEAFOKMSG_H__
#define __GNUTLEAFOKMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

class GnutCoord;

//=============================================================================
class GnutLeafOkMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutLeafOkMsg(const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutLeafOkMsg(const void* aMem);

    virtual ~GnutLeafOkMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutLeafOkMsg(const GnutLeafOkMsg&);
    GnutLeafOkMsg& operator=(const GnutLeafOkMsg&);
};
//=============================================================================
#endif /* __GNUTLEAFOKMSG_H__ */

