//=============================================================================
// File: gnutquerymsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a query message.
//=============================================================================

#ifndef __GNUTQUERYMSG_H__
#define __GNUTQUERYMSG_H__

#include "gnutbinarymsgbc.h"
#include "gnut_types.h"

class GnutQueryMsg : public GnutBinaryMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutQueryMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops, 
                 const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutQueryMsg(const void* aMem);

    virtual ~GnutQueryMsg(void);

    // = ACTION 

    void writeToPacket(void* aMem) const;
 

    // = ACCESS
    
    size_t getSize(void) const;

    double getTimeSent(void) const { return mTimeSent; }


private:
    // = DATA

    double mTimeSent;


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutQueryMsg(const GnutQueryMsg&);
    GnutQueryMsg& operator=(const GnutQueryMsg&);
};
//=============================================================================
#endif /* __GNUTQUERYMSG_H__ */

