//=============================================================================
// File: gnutqueryrecord.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutqueryrecord.h"
#include "gnut_util.h"

//=============================================================================
GnutQueryRecord::
GnutQueryRecord(void)
{ }
//=============================================================================
GnutQueryRecord::
GnutQueryRecord(double aTimeSent)
: mTimeSent(aTimeSent) 
{ }
//=============================================================================
GnutQueryRecord::
~GnutQueryRecord(void)
{ }
//=============================================================================
GnutQueryRecord::
GnutQueryRecord(const GnutQueryRecord& aRecord)
: mTimeSent(aRecord.mTimeSent),
  mNodeTimes(aRecord.mNodeTimes),
  mNodes(aRecord.mNodes),
  mHitTimes(aRecord.mHitTimes)
{ 
    GnutUtil::gnutTrace("GnutQueryRecord copy constructor\n");
}
//=============================================================================
GnutQueryRecord& 
GnutQueryRecord::operator=(const GnutQueryRecord& aRecord)
{
    GnutUtil::gnutTrace("GnutQueryRecord operator=()\n");

    if (this != &aRecord)
    {
        this->mTimeSent = aRecord.mTimeSent;
        this->mNodeTimes = aRecord.mNodeTimes;
        this->mNodes = aRecord.mNodes;
        this->mHitTimes = aRecord.mHitTimes;
    }

    return *this;
}
//=============================================================================
void 
GnutQueryRecord::
newNodeTime(NodeAddr_t aNode, double aTime)
{
    NodeSet::const_iterator iter = mNodes.find(aNode);

    if (iter == mNodes.end())
    {
        mNodeTimes.push_back(aTime);
        mNodes.insert(aNode);
    }
}
//=============================================================================
void 
GnutQueryRecord::
newHitTime(double aTime)
{
    mHitTimes.push_back(aTime);
}
//=============================================================================

