//=============================================================================
// File: ignuteventlistener.h
// Author: Andre Dufour
//
// Class type: interface
// Description: implemented by classes wanting to be advised of Gnutella events
//=============================================================================

#ifndef __IGNUTEVENTLISTENER_H__
#define __IGNUTEVENTLISTENER_H__

class IGnutEventListener
{
protected:
    // = FOUNDATION

    IGnutEventListener(void);
    virtual ~IGnutEventListener(void);

public:
    // = ACTION

    virtual void notify(void) const = 0;

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    IGnutEventListener(const IGnutEventListener&);

    IGnutEventListener& operator=(const IGnutEventListener&);
};
//=============================================================================
#endif /* __IGNUTEVENTLISTENER_H__ */

