// File: peersys.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __PEERSYS_H__
#define __PEERSYS_H__

#include "gnut_types.h"

//=============================================================================
class PeerSys: public TclObject {
 public:
  PeerSys();

  int nFiles_; //number of popular files studied
  int nClasses_; //number of classes (of peers)
  double *cdffile_; //CDF of a file being queried for
  double alpha_; //alpha in the Pareto distribution of file popularity
  ClassMap_t classes_;

  virtual void init_file();
  virtual void init_class(FILE *fh);

 protected:
  int command(int, const char*const*);
};

//=============================================================================

#endif /* __PEERSYS_H__ */

