/*-------------------------------------------------------------------------*/
/* AdvwTcpAgent: subclass of FullTcpAgent that has receiver advertised     */
/* window and application-limited consumption on receiver                  */
/* Author: Qi He <http://www.cc.gatech.edu/~qhe> 01Aug2003                 */
/* $Revision:$ $Name:$ $Date:$                                             */
/*-------------------------------------------------------------------------*/
#ifndef NS_TCP_ADVW
#define NS_TCP_ADVW

#include "tcp-full.h"
#include "packet.h"
#include "app.h"

class AdvwTcpApplication;

class AdvwTcpAgent: public FullTcpAgent {
public:
	AdvwTcpAgent();
	virtual ~AdvwTcpAgent();

	int rcv_buff_; //receiver buffer limit
	int num_bytes_req_; //number of bytes requested by user so far
	int num_bytes_avail_; //number of bytes in the receiver buffer
	int infinite_rcv_;
	int rcv_wnd_;
        AdvwTcpApplication *app_;

	virtual void recv(Packet *pkt, Handler*);
	void tcp_command_block_receive(int num_bytes);
	void tcp_command_nonblock_receive(int num_bytes);
	void sendpacket(int seqno, int ackno, int pflags, int datalen, int reason);	
	virtual void attachApp(Application* app);
 protected:

	void newack(Packet *);
	virtual void recvBytes(int);
	int command(int argc, const char*const* argv);
};

class AdvwTcpApplication: public Application {
public:
  AdvwTcpApplication();
  virtual ~AdvwTcpApplication();

  int curlen_;
  virtual int upcall_recv(Packet *);
  virtual int upcall_recv(int nbytes) { return nbytes;}
  virtual void upcall_send();
  virtual void upcall_closing() ;
  void sendmsg(int, PacketData *);
  void sendpacket(int seqno, int ackno, int pflags, int datalen, int reason, PacketData *data);

protected:
  int command(int argc, const char*const* argv);
  AdvwTcpAgent *awagent_;

};

#endif

