// File: ultraagent.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __ULTRAAGENT_H__
#define __ULTRAAGENT_H__

#include "gnutellaagent.h"
#include "gnut_types.h"

struct GnutDescHdr;

/* GnutellaAgent for an Ultrapeer */
class UltraAgent: public GnutellaAgent {
public:
    // = FOUNDATION

    UltraAgent(GnutellaApp* aApp);
    UltraAgent(NodeAddr_t aNode);
    virtual ~UltraAgent(void);


    // = ACTION

    virtual void Ping(NodeAddr_t peer, int ttl);
    virtual void Query(NodeAddr_t peer);
    virtual int forward(Socket* incoming, PacketData* data, const GnutDescHdr& hdr);
    virtual void gnutella_req(Socket* sock);
    virtual void gnutella_ok(Socket* sock);
    virtual void gnutella_leaf_guidance(Socket* sock);

private:
    // = FOUNDATION
    UltraAgent(const UltraAgent&);
    UltraAgent& operator=(const UltraAgent&);
};

#endif /* __ULTRAAGENT_H__ */

