// File: ultrapeer.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __ULTRAPEER_H__
#define __ULTRAPEER_H__

#include "gnut_types.h"
#include "gnutellaapp.h"

struct PongRes;
class GnutHierApp;
class GnutCoord;

//=============================================================================
/* Ultrapper Gnutella Application */
class Ultrapeer: public GnutellaApp {
public:
    // = FOUNDATION

    Ultrapeer(NodeAddr_t addr, const char* const parent, int aUsesVivaldi);
    virtual ~Ultrapeer(void);
    

    // = ACTION

    virtual void bootstrap();
    virtual bool  avail(EPeerType aType) const; //available for a particular type of connection
    virtual void connect(bool aTryBootserver, bool* aReloadTimer = 0);
    virtual void ping();
    virtual void ConnectSucceeded(NodeAddr_t, EGnutApp type, 
        const GnutCoord& remoteCoord, double remoteError);
    virtual int  ConnectionRequest(NodeAddr_t, Socket *, const GnutCoord& coord, double remoteError, double timeSent);
    virtual int  UltraConnRequest(NodeAddr_t, Socket *, const GnutCoord& coord, double remoteError, double timeSent);
    virtual void UltraLeafGuidance(NodeAddr_t aPeer);
    virtual int  LeafConnRequest(NodeAddr_t, Socket *, const GnutCoord& coord, double remoteError, double timeSent);
    virtual void PongReply(NodeAddr_t peer, const PongRes& pong);
    virtual void setState(PeerState_t newstate);

private:
    // = DATA

    int max_peer_; //maximum number of ultrapeer connections
    int max_leaves_; //maximum number of leaf connections
    int max_legacy_; //maximum number of legacy peer connetions
    int npeers_; //number of ultrapeer connections 
    int nleaves_; //number of leaf connections
    int nlegacy_; //number of legacy peer connections


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    Ultrapeer(const Ultrapeer&);
    Ultrapeer& operator=(const Ultrapeer&);
};


#endif /* __ULTRAPEER_H__ */

