//=============================================================================
// File: vivaldimanagerbc.h
// Author: Andre Dufour
//
// Class type: concrete base class
// Description: Null implementation for the Vivaldi cooridnate system.
//=============================================================================

#ifndef __VIVALDIMANAGERBC_H__
#define __VIVALDIMANAGERBC_H__

#include "ivivaldimanager.h"
#include "gnutcoord.h"

class VivaldiManagerBC : public IVivaldiManager
{
    // = FOUNDATION
public:
    VivaldiManagerBC(void);
    virtual ~VivaldiManagerBC(void);


    // = IVivaldiManager

    virtual GnutCoord getCoordinates(void) const;

    virtual void updateCoordinates(
            const GnutCoord& aRemoteCoord,
            double aRtt,
            double aRemoteError);

    virtual void resetCoordinates(void);

    virtual double getLocalError(void) const;

    virtual double estimateRtt(const GnutCoord& aRemoteCoord) const;

private:

    // = FOUNDATION

    // Disable copy constructor and assignment operator
    VivaldiManagerBC(const VivaldiManagerBC&);
    VivaldiManagerBC& operator=(const VivaldiManagerBC&);

};
//=============================================================================
#endif /* __VIVALDIMANAGERBC_H__ */

