// File: pingtimer.cc
// Original by Qi He
// Modified by Andre Dufour

#include "watchdog.h"

class Event;

const unsigned int WatchDog::WATCH_INTERVAL   = 20; // seconds
//const unsigned int WatchDog::WATCH_INTERVAL   = 120; // seconds

//=============================================================================
/* Connection watchdog */
WatchDog::WatchDog(const IGnutEventListener& aListener) 
: mListener(aListener)
{ }
//=============================================================================
WatchDog::~WatchDog(void)
{ }
//=============================================================================
void WatchDog::expire(Event*) 
{
    mListener.notify();
}
//=============================================================================
void WatchDog::resched(void)
{
    TimerHandler::resched(WATCH_INTERVAL);
}
//=============================================================================

