# Script demonstrating the use of GnutellaSim in ns2
# Q. He (08/01/2003)

# Generated by sgb2ns, created by Polly Huang
# GRAPH (#nodes #edges id uu vv ww xx yy zz):
# 100 374 transtub(0,3,0,0,{1,89,3,0.500,1.000,0.100},{4,44,3,0.600,1.000,0.100},{8,36,3,0.420,1.000,0.100}) 89 2 5 0 

set nam_trace 0

source gnbrite2.tcl

# the main procedure
proc run {} {
    global p cnt ns n

    # configure the Gnutella system parameters
    set sys [new PeerSys 100 2 2]
    $sys init-class classinfo.txt

    # create simple simulated bootstrap server
    set bootserver [new SocketApp/SmpBootServer]

    puts "start config"
    set rng [new RNG]
    $rng seed 2
    for {set i 0} {$i < $cnt } {incr i} {
        set p($i) ""

        # peers are only attached to leaf nodes
        set nodeid [$n($i) node-addr] 

        # TODO: ???
#        if { $i%10!=0 } {
#            continue
#        }

        # create and set up a Gnutella servent
        set ptype [$rng uniform 0 10]
        if {$ptype < 2 } {
            set p($i) [new GnutHierApp $nodeid "LegacyActive"]
        } elseif {$ptype < 6 } {
            set p($i) [new GnutHierApp $nodeid "LeafActive"]
        } else {
            set p($i) [new GnutHierApp $nodeid "UltrapeerActive"]
        }

        $p($i) use-smpbootserver $bootserver
        
        # attach the servent to the p2p system 
        set pfreeloader [$rng uniform 0 100]
        if {$pfreeloader < 50 } { ; # 50% are freeloaders
            $p($i) attach-peersys $sys 0
        } else {
            $p($i) attach-peersys $sys 1
        }
    
        set stime [$rng uniform 0 100]
        $ns at $stime "$p($i) start"
        puts "peer $i nodeid $nodeid start at $stime"

    }    
    
    # print out a timestamp periodically
    for {set i 1} {$i<20 } {incr i} {
        set timestamp [expr $i*50]
        set msg "timestamp${timestamp}"
        $ns at $timestamp "puts $msg"
    }
    puts "end config"

    # TODO: AD remove
    $ns at 700 "$p(1) setActiveApplication 1 LegacyActive"
    $ns at 701 "$p(1) start"

    $ns run
}

proc finish {} {
    global p cnt nf nam_trace

    for {set i 0 } {$i<$cnt} {incr i} {
        if {$i%10==0} {
        $p($i) stop
        }
    }    
    puts "finished, dumping statistics..."
    for {set i 0 } {$i<$cnt} {incr i} {
        #if {$i%10==0} {
            puts "Asking peer $i for stats"
            $p($i) statistics
        #}
    }    

    puts "All done dumping stats"

    if {$nam_trace != 0} {
        close $nf
        exec ../nam-1.9/nam gnuttrace.nam &
    }
    exit 0
}

set ns [new Simulator]
set cnt 4
if {$nam_trace != 0} {
    set nf [open gnuttrace.nam w]
    $ns namtrace-all $nf
}

create_topology

$ns at 1500 "finish"
run 
