// File: gnut_util.h
// Original by Qi He
// Modified by Andre Dufour

#include "gnut_types.h"

//=============================================================================
void debug_info(char *format, ...) {
  va_list ap;
  
  if(getenv("GNUSIM_INFO")!=NULL) {
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);
  }
  fflush(NULL);
};
//=============================================================================
void debug_warning(char *format, ...) {
  va_list ap;
  
  if(getenv("GNUSIM_WARNING")!=NULL) {
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);
  }
  fflush(NULL);
};
//=============================================================================
void debug_stat(char *format, ...) {
  va_list ap;
  
  if(getenv("GNUSIM_NOSTAT")==NULL) {
    va_start(ap, format);
    vfprintf(stdout, format, ap);
    va_end(ap);
  }
  fflush(NULL);
};
//=============================================================================

