// File: gnutellamsg.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __GNUTELLAMSG_H__
#define __GNUTELLAMSG_H__

#include "gnut_types.h"

//============================================================================
/* Gnutella Message Handler */
class GnutellaMsg 
{
public:
    // = FOUNDATION

    GnutellaMsg(NodeAddr_t);
    virtual ~GnutellaMsg(void); 


    // = ACTION

    virtual int parse(int len, unsigned char *);
    int clear();
    char *new_descid();
    PacketData *newpacket(char *id, Byte_t type, int ttl, int hops, 
                          int length, char *);

    // = DATA
    desc_hdr header_;

    union tPayload {
        tPong *pong_;
        tQuery *query_;
        tQueryHit *queryhit_;
        tPush *push_;
    };

    tPayload payload_;
    //the DescriptIDs for messages from a servent are generated with three
    //integers and the node address of the peer (last 4 bytes)
    int seq1_;
    int seq2_;
    int seq3_;
    NodeAddr_t addr_;


private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutellaMsg(const GnutellaMsg&);
    GnutellaMsg& operator=(const GnutellaMsg&);


};

//============================================================================

#endif /* __GNUTELLAMSG_H__ */

