//=============================================================================
// File: gnuthierapp.cc
// Author: Andre Dufour
//=============================================================================

#include "gnuthierapp.h"
#include "gnut_types.h"
#include "leaf.h"
#include "ultrapeer.h"
#include "gnut_util.h"
#include "tclcl.h"

//=============================================================================
unsigned long GnutHierApp::mUltrapeerMinTime = 0;
const char* GnutHierApp::APP_NAMES[EGnutAppLast] = 
                           { "LeafActive", "UltrapeerActive", "LegacyActive" };
//=============================================================================
//GnutHierApp::
//GnutHierApp(NodeAddr_t aAddr, EGnutAppType aInitAppType, 
//            bool aUltrapeerCapable)
//: mAddr(aAddr),
//  mActiveApp(0),
//  mUltrapeerCapable(aUltrapeerCapable)
//{
//    GNUT_ASSERT(!((aInitAppType == EGnutAppUltrapeer) && 
//                  (aUltrapeerCapable == false)));
//    setActiveApp(aInitAppType);
//}
//=============================================================================
GnutHierApp::
GnutHierApp(NodeAddr_t aAddr)
: mAddr(aAddr),
  mActiveApp(0),
  mUltrapeerCapable(false),
  mRole(EGnutAppLast)
{
    // TODO: AD - test ultrapeer capability!


    // TODO: AD - wish there was a more elegant way to do this.
    mAppActiveAction[EGnutAppLeaf] = &GnutHierApp::leafActive;
    mAppActiveAction[EGnutAppUltrapeer] = &GnutHierApp::ultrapeerActive;
    mAppActiveAction[EGnutAppLegacy] = &GnutHierApp::legacyActive;
}
//=============================================================================
// TODO: AD remove this one.
//GnutHierApp::
//GnutHierApp(NodeAddr_t aAddr)
//: mAddr(aAddr),
//  mActiveApp(0),
//  mUltrapeerCapable(false)
//{
//printf("Constr called\n\n\n");
////    setActiveApp(EGnutAppLegacy);
//}
//=============================================================================
GnutHierApp::
~GnutHierApp(void)
{
    // TODO: AD perform other cleanup?
    printf("GnutHierApp::dtor called\n");
    delete mActiveApp;
    mActiveApp = 0;
}
////=============================================================================
//void
//GnutHierApp::
//join()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->join();
//}
////=============================================================================
//void
//GnutHierApp::
//leave()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->leave();
//}
////=============================================================================
//void
//GnutHierApp::
//search(char* aCriteria)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->search(aCriteria);
//}
////=============================================================================
//void
//GnutHierApp::
//share()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->share();
//}
////=============================================================================
//void
//GnutHierApp::
//setState(PeerState_t aNewstate)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->setState(aNewstate);
//}
////=============================================================================
//void
//GnutHierApp::
//setFreeloader(int aFreeloader)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->setFreeloader(aFreeloader);
//}
////=============================================================================
//void
//GnutHierApp::
//bootstrap()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->bootstrap();
//}
////=============================================================================
//void
//GnutHierApp::
//maintenance()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->maintenance();
//}
////=============================================================================
//void
//GnutHierApp::
//connect()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->connect();
//}
////=============================================================================
//void
//GnutHierApp::
//stop()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->stop();
//}
////=============================================================================
//void
//GnutHierApp::
//disconnect(NodeAddr_t aNode)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->disconnect(aNode);
//}
////=============================================================================
//void
//GnutHierApp::
//update_bootcache()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->update_bootcache();
//}
////=============================================================================
//void
//GnutHierApp::
//ConnectSucceeded(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->ConnectSucceeded(aPeer);
//}
////=============================================================================
//void
//GnutHierApp::
//ConnectionRejected(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->ConnectionRejected(aPeer);
//}
////=============================================================================
//void
//GnutHierApp::
//ConnectionFailed(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->ConnectionFailed(aPeer);
//}
////=============================================================================
//void
//GnutHierApp::
//ConnectionTimeout(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->ConnectionTimeout(aPeer);
//}
////=============================================================================
//void
//GnutHierApp::
//ConnectionClosed(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->ConnectionClosed(aPeer);
//}
////=============================================================================
//int
//GnutHierApp::
// ConnectionRequest(NodeAddr_t aPeer, Socket *aSocket)
//{   
//    GNUT_ASSERT(mActiveApp);
//    return mActiveApp->ConnectionRequest(aPeer, aSocket);
//}
////=============================================================================
//int
//GnutHierApp::
//UltraConnRequest(NodeAddr_t aPeer, Socket *aSocket)
//{
//    GNUT_ASSERT(mActiveApp);
//    return mActiveApp->UltraConnRequest(aPeer, aSocket);
//}
////=============================================================================
//int
//GnutHierApp::
//LeafConnRequest(NodeAddr_t aPeer, Socket *aSocket)
//{ 
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->LeafConnRequest(aPeer, aSocket);
//}
////=============================================================================
//void
//GnutHierApp::
//PingRequest(NodeAddr_t aPeer, int aTtl, char *aId)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->PingRequest(aPeer, aTtl, aId);
//}
////=============================================================================
//void
//GnutHierApp::
//PongReply(NodeAddr_t aPeer, int aTtl, char* aPayload)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->PongReply(aPeer, aTtl, aPayload);
//}
////=============================================================================
//void
//GnutHierApp::
//QueryRequest(NodeAddr_t aPeer, int aTtl, char* aPayload, 
//             char *aId)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->QueryRequest(aPeer, aTtl, aPayload, aId);
//}
////=============================================================================
//void
//GnutHierApp::
//QueryHitReply(NodeAddr_t aPeer, int aTtl, char* aPayload)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->QueryHitReply(aPeer, aTtl, aPayload);
//}
////=============================================================================
//void
//GnutHierApp::
//BootstrapRequest(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->BootstrapRequest(aPeer);
//}
////=============================================================================
//void
//GnutHierApp::
//BootstrapResult(int aCnt, NodeAddr_t *aRes)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->BootstrapResult(aCnt, aRes);
//}
////=============================================================================
//void
//GnutHierApp::
//BootcacheUpdate(NodeAddr_t aPeer)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->BootcacheUpdate(aPeer);
//}
////=============================================================================
//void
//GnutHierApp::
//ping()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->ping();
//}
////=============================================================================
//int
//GnutHierApp::
//avail(int aType)
//{ 
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->avail(aType);
//}
////=============================================================================
//void
//GnutHierApp::
//smp_bootstrap()
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->smp_bootstrap();
//}
////=============================================================================
//void
//GnutHierApp::
//setBootServer(FILE * aFile)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->setBootServer(aFile);
//}
////=============================================================================
//int
//GnutHierApp::
//find_servent(NodeAddr_t aServent)
//{ 
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->find_servent(aServent);
//}
////=============================================================================
//void
//GnutHierApp::
//remove_servent(NodeAddr_t aServent)
//{
//    GNUT_ASSERT(mActiveApp);
//    mActiveApp->remove_servent(aServent);
//}
//=============================================================================
int
GnutHierApp::
command(int argc, const char*const* argv)
{ 
    // TODO: AD change to strncmp
    if (strcmp(argv[1], "linkActiveApp") == 0)
    {
        if (argc == 4)
        {
            for (unsigned int iter = 0; iter < EGnutAppLast; iter++)
            {
                if (strcmp(argv[2], APP_NAMES[iter]) == 0)
                {
                    return (this->*mAppActiveAction[iter])(argv[3]);
                }
            }
        }
        return TCL_ERROR;
    }
    else if (strcmp(argv[1], "debug_status") == 0)
    {
        mActiveApp->debug_status();
    }

    GNUT_ASSERT(mActiveApp);
    mActiveApp->command(argc, argv);

    return TCL_OK;
}
//=============================================================================
// Static
void 
GnutHierApp::
setMinUltrapeerTime(unsigned long aSeconds)
{
    GnutHierApp::mUltrapeerMinTime = aSeconds;
}
//=============================================================================
int
GnutHierApp::
leafActive(const char* const aApp)
{
    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?

    mRole = EGnutAppLeaf;
    mActiveApp = reinterpret_cast<Leaf*>(TclObject::lookup(aApp));
   
    return TCL_OK;
}
//=============================================================================
int
GnutHierApp::
ultrapeerActive(const char* const aApp)
{
    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?

    mRole = EGnutAppUltrapeer;
    mActiveApp = reinterpret_cast<Ultrapeer*>(TclObject::lookup(aApp));
    return TCL_OK;
}
//=============================================================================
int
GnutHierApp::
legacyActive(const char* const aApp)
{
    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?

    mRole = EGnutAppLegacy;
    mActiveApp = reinterpret_cast<GnutellaApp*>(TclObject::lookup(aApp));
    return TCL_OK;
}
//=============================================================================
static class GnutHierAppClass: public TclClass {
public:
  GnutHierAppClass(): TclClass("GnutHierApp") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new GnutHierApp(atoi(argv[4])));
  }
}class_gnuthierapp;
//=============================================================================

