#############################################################################
# File: gnuthierapp.tcl
# Author: Andre Dufour
#
#
#############################################################################

#Class GnutHierApp


#############################################################################
# Constructor
GnutHierApp instproc init { aAddr aActiveApp aBootServer aPeerSys aFreeLoader } {
    $self next
    $self instvar mPeerSys mBootServer mFreeLoader

    if {$aFreeLoader != 0 && $aFreeLoader != 1} {
        # TODO: AD return an error
        puts "Invalid freeloader value ($aFreeLoader). Must be 0 or 1"
    }

    set mPeerSys $aPeerSys
    set mBootServer $aBootServer
    set mFreeLoader $aFreeLoader

    $self setActiveApplication $aAddr $aActiveApp
}
#############################################################################
GnutHierApp instproc setActiveApplication { aAddr aActiveApp } {
    $self instvar mActiveApp mPeerSys mBootServer mFreeLoader

    if { [string compare $aActiveApp "LegacyActive"] == 0 } {
        puts "Building legacy app"
        if {[info exists mActiveApp] == 1} {
            puts "deleting old app"
            $mActiveApp cleanup
            #$mActiveApp destroy
            unset mActiveApp
        }
        set mActiveApp [new PeerApp/GnutellaApp $aAddr 0]
        puts "Done building legacy in TCL"
    } elseif {[string compare $aActiveApp "UltrapeerActive"] == 0 } {
        set mActiveApp [new PeerApp/GnutellaApp/Ultrapeer $aAddr 0]
    } elseif { [string compare $aActiveApp "LeafActive"] == 0 } {
        set mActiveApp [new PeerApp/GnutellaApp/Leaf $aAddr 0]
    } else {
        puts "Error: invalid app type $aActiveApp"
        # TODO: AD return error
    }

    $self linkActiveApp $aActiveApp $mActiveApp

    $self use-smpbootserver $mBootServer
    # TODO: AD fix freeloader param later
    #$mNs after 1 "$self attach-peersys $mPeerSys $mFreeLoader"
}
#############################################################################

