// File: leafagent.cc
// Original by Qi He
// Modified by Andre Dufour

#include "leafagent.h"
#include "gnut_types.h"
#include "gnutellamsg.h"
#include "gnutellaapp.h"
#include "peersys.h"
#include "gnut_util.h"
#include "pendingreqentry.h"
#include "conntimer.h"

//=============================================================================

/* PeerAgent for Leaf */
LeafAgent::LeafAgent(NodeAddr_t addr): GnutellaAgent(addr) {
}
//=============================================================================
LeafAgent::LeafAgent(GnutellaApp *app): GnutellaAgent(app) {
}
//=============================================================================
LeafAgent::~LeafAgent(void)
{ }
//=============================================================================
int LeafAgent::upcall_recv(Socket *sock, PacketData *pktdata, Handler *) {
 
  char teststring[CONN_LEN];
  unsigned char *data = pktdata->data();
  NodeAddr_t src;
  int msg, res, cnt, block=FALSE, nhit;
  SockMap_t::iterator si;
  PendingConns_t::iterator pi;

  //continue only if peer is currently online
  if(app_->state_==PS_OFFLINE) {
    msgHandle_.clear();
    return pktdata->size();  
  }

  src = sock->peer_.addr_;
  msg = msgHandle_.parse(pktdata->size(), data);

  switch(msg) {
  case MSG_BOOTSTRAP:
  case MSG_CONNREQ:
  case MSG_ULTRACONNREQ:
  case MSG_LEAFCONNREQ:
  case MSG_PING:  
    break;

  case MSG_BOOTSTRAP_RES:
    cnt = *((int *)(data + BOOTSTRAP_RESLEN));
    gapp_->BootstrapResult(cnt, (NodeAddr_t *)
                           (data + BOOTSTRAP_RESLEN + sizeof(int)));
    break;

  case MSG_CONNOK:
    for(PendingConns_t::iterator i = conn_pending_.begin(); 
        i != conn_pending_.end(); 
        i++) {
      if(i->second.peer_==src) {
        conn_pending_.erase(i);
        break;
      }
    }

    si = lsocks_.find(src);
    if(si==lsocks_.end()) {
      SockEntry *newentry = new SockEntry(sock, src, SOCK_ULTRA);
      lsocks_.insert(SockMap_t::value_type(src, *newentry));
    }
    gapp_->ConnectSucceeded(src); 

    break;

  case MSG_CONNREJ:
    pi = conn_pending_.find(src);
    if(pi!=conn_pending_.end()) {
      gapp_->ConnectionRejected(src);

      for(pi=conn_pending_.begin(); pi!=conn_pending_.end(); pi++) {
        if(pi->second.peer_==src) {
          conn_pending_.erase(pi);
	  
          sock->close();
          break;
	    }
      }
    }
    break;

  case MSG_PONG:
    if(find_desc(msgHandle_.header_.id_)==NULL && find_ping(msgHandle_.header_.id_, 0)==-1)
      break;

    gapp_->PongReply(src, msgHandle_.header_.TTL_, (char *)msgHandle_.payload_.pong_);
    if(find_desc(msgHandle_.header_.id_)==NULL) {
      pongcnt++;
    }
    break;

  case MSG_QUERY:
    if(find_desc(msgHandle_.header_.id_)!=NULL)
      break;

    if(find_query(msgHandle_.header_.id_, 1)!=-1)
      break;

    gapp_->QueryRequest(src, msgHandle_.header_.TTL_, 
                        (char *)msgHandle_.payload_.query_->criteria_, 
                        msgHandle_.header_.id_);
    break;

  case MSG_QUERYHIT:
    if(find_desc(msgHandle_.header_.id_)==NULL && 
       find_query(msgHandle_.header_.id_, 0)==-1) {
      break;
    }

    gapp_->QueryHitReply(src, msgHandle_.header_.TTL_, 
                         (char *)msgHandle_.payload_.queryhit_);

    if(find_desc(msgHandle_.header_.id_)==NULL) 
      nqueryhit++;

    break;

  default: 
    debug_warning("WARNING: unknown Message Type\n");
    break;

  };

  msgHandle_.clear();
  return pktdata->size();  
}

//=============================================================================
void LeafAgent::gnutella_req(Socket *sock) {
  PacketData *content;
  unsigned char *dataptr;
  char connstr[LEAFCONN_LEN];

  content = new PacketData(LEAFCONN_LEN-1);
  dataptr = content->data();
  strcpy((char *)connstr, LEAF_CONN);
  memcpy(dataptr, connstr, LEAFCONN_LEN-1); 

  sock->send(LEAFCONN_LEN-1, content);
  
  if(conn_pending_.size()==1)
    conn_timer_.resched(CONN_TIMEOUT);
}

//=============================================================================
static class LeafAgentClass: public TclClass {
public:
  LeafAgentClass(): TclClass("SocketApp/PeerAgent/GnutellaAgent/LeafAgent") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new LeafAgent(atoi(argv[4])));
  }
}class_leafagent;
//=============================================================================


