// File: smpbootserver.cc
// Original by Qi He
// Modified by Andre Dufour

#include "smpbootserver.h"
#include "gnut_types.h"
#include "gserventrec.h"
#include "gnutellaapp.h"
#include "gnut_util.h"

//=============================================================================
SmpBootServer::SmpBootServer() 
{ }
//=============================================================================
SmpBootServer::~SmpBootServer() 
{ }
//=============================================================================
void SmpBootServer::RemovePeer(NodeAddr_t peer, GnutellaApp *app) 
{
    GServentMap_t::iterator fi = servent_cache_.find(peer);

    if(fi!=servent_cache_.end()) 
    {
      servent_cache_.erase(fi);
    }
}
//=============================================================================
/* called directly by a new servent for bootstrapping */
BootstrapRes_t *SmpBootServer::BootstrapRequest(
    NodeAddr_t peer, GnutellaApp* app, EPeerType peertype) 
{
    BootstrapRes_t* res;
    int i = 0;
    int cnt = 0, asize = 0; 
    double thresh, prob;

    debug_stat("smp bootstrap request from %d\n", peer);

    for(GServentMap_t::const_iterator fi = servent_cache_.begin(); 
        fi != servent_cache_.end(); 
        ++fi) 
    {
        if(fi->second.app_->avail(peertype))
            cnt++;
    }

    asize = cnt > MAX_BOOTREPLY? MAX_BOOTREPLY:cnt;
    if (cnt <= MAX_BOOTREPLY)
        thresh = 1;
    else
        thresh = (float)MAX_BOOTREPLY/(float)cnt;

    res = (BootstrapRes_t *)malloc(sizeof(BootstrapRes_t));
    NodeAddr_t *addrs = (NodeAddr_t *)malloc(sizeof(NodeAddr_t)*asize);
    for(GServentMap_t::const_iterator fi = servent_cache_.begin(); 
        fi != servent_cache_.end(); 
        ++fi) 
    {
        if(!fi->second.app_->avail(peertype))
          continue;
        prob = (double)rand()/(double)RAND_MAX;
        if(prob <= thresh) 
        {      
            // TODO: AD
            printf("Adding %d to result set\n", fi->second.addr_);
            fflush(NULL);

            addrs[i] = fi->second.addr_;
            i++;
            if(i>=asize)
                break;
        }
    }

    res->cnt_ = i;
    res->servents_ = addrs;
    if(peertype!=EPeerLeaf) 
    {
        GServentMap_t::const_iterator fi = servent_cache_.find(peer);
        if(fi==servent_cache_.end()) 
        {
            // TODO: AD
            printf("Adding %d to cache\n", peer);
            fflush(NULL);

            GServentRec *newsrv;
            newsrv = new GServentRec(LISTEN_PORT, peer, 0, 0, app);
            servent_cache_.insert(GServentMap_t::value_type(peer, *newsrv));
        }
    }
    return res;
}
//=============================================================================
static class SmpBootServerClass: public TclClass {
public:
  SmpBootServerClass(): TclClass("SocketApp/SmpBootServer") {}
  TclObject* create(int, const char*const* argv) {
    return (new SmpBootServer());
  }
}class_smpbootserver;
//=============================================================================


