// File: ultraagent.cc
// Original by Qi He
// Modified by Andre Dufour

#include "ultraagent.h"
#include "gnut_types.h"
#include "gnutellaagent.h"
#include "gnutellaapp.h"
#include "pendingreqentry.h"
#include "gnutellamsg.h"
#include "gnut_util.h"
#include "conntimer.h"


//=============================================================================
/* PeerAgent for Ultrapper Application*/
UltraAgent::UltraAgent(NodeAddr_t addr): GnutellaAgent(addr) {
}

//=============================================================================
UltraAgent::UltraAgent(GnutellaApp *app): GnutellaAgent(app) {
}

//=============================================================================
UltraAgent::~UltraAgent(void)
{ }
//=============================================================================
/* send PING to a peer */
void UltraAgent::Ping(NodeAddr_t peer, int ttl) {
  PacketData *pkt;

  SockMap_t::iterator si = lsocks_.find(peer);
  if(si==lsocks_.end()) {
    debug_warning("WARNING: %d error pinging unconnected peer %d\n", app_->addr_, peer);
    return;
  } 

  pkt = msgHandle_.newpacket(NULL, PING, ttl, 0, 0, NULL); 

  if(pkt) {
    si->second.sock_->send(DESC_HDRLEN, pkt);
    PendingReqEntry *newquery = new PendingReqEntry(msgHandle_.header_.id_, NOW, REQ_PING);
    pending_req_.insert(pending_req_.end(), *newquery);
  }
  return;
}

//=============================================================================
/* send a Query */
void UltraAgent::Query(NodeAddr_t peer, Word_t minSpeed, char *search) {
  SockMap_t::iterator si;
  char *data;
  PacketData *pkt=NULL;
  int len = strlen(search) + 1;
  float hprob;
  char *id = NULL;

  data = (char *)malloc(len+sizeof(Word_t));
  memcpy((void *)data, (void *)&minSpeed, sizeof(Word_t));
  strcpy((char *)&data[sizeof(Word_t)], search);
  
  nquery++;

  if(peer==-1) { //send to all connected peers
    for(si = lsocks_.begin(); si != lsocks_.end(); si++) {
      if (si->second.type_==SOCK_LEAF) { 
	//send to a leaf peer only with certain probability
	//QRP is not implemented yet
	hprob = (float)rand()/(float)RAND_MAX;
	if(hprob < QRP_HITPROB) 
		continue;
      }
      pkt = msgHandle_.newpacket(id, QUERY, INIT_TTL, 0, len + 2, data);
      if(pkt) {
	  si->second.sock_->send(len+2+DESC_HDRLEN, pkt);
	  if(id==NULL)
	    id = msgHandle_.header_.id_;
	}
    }

    PendingReqEntry *newquery = new PendingReqEntry(msgHandle_.header_.id_, NOW, REQ_QUERY);
    pending_req_.insert(pending_req_.end(), *newquery);
    free(data);
    return;
  }

  //or, send to a specific peer
  si = lsocks_.find(peer);
  if(si==lsocks_.end()) {
    debug_warning("WARNING: error sending Query to unconnected peer %d\n", peer);
    free(data);
    return;
  }

  if (si->second.type_==SOCK_LEAF)
    return;
  pkt = msgHandle_.newpacket(NULL, QUERY, INIT_TTL, 0, len+2, data);  
  free(data);
  if(pkt) {
    si->second.sock_->send(len+2+DESC_HDRLEN, pkt);

    PendingReqEntry *newquery = new PendingReqEntry(msgHandle_.header_.id_, NOW, REQ_QUERY);
    pending_req_.insert(pending_req_.end(), *newquery);
  }
}

//=============================================================================

/* forward a PING or Query message */
int UltraAgent::forward(Socket *incoming, PacketData *data, desc_hdr *hdr) 
{
    PacketData *newdata=NULL;
    DescEntry* newentry=NULL;
    int bcnt=0, totalout=0;
    int fcnt=0;

    for(SockMap_t::iterator si = lsocks_.begin(); si!=lsocks_.end(); si++) 
    {
        if(si->second.sock_!=incoming && si->second.type_!=SOCK_LEAF) 
        {
            totalout++;
            if(si->second.sock_->blocked(SOCK_WRITE)) 
            {
                bcnt++;
                fwblock_.increment();
            }
        }
    }

    for(SockMap_t::iterator si = lsocks_.begin(); si!=lsocks_.end(); si++) 
    {
        if(si->second.sock_!=incoming && !si->second.type_!=SOCK_LEAF) 
        {
            if(!si->second.sock_->blocked(SOCK_WRITE)) 
            {
                newdata = new PacketData(*data);
                si->second.sock_->send(data->size(), newdata);
            } 
        }
    }

    newentry = new DescEntry(hdr->id_, incoming, NOW);
    desc_cache_.insert(desc_cache_.end(), *newentry);
    return FALSE;
}

//=============================================================================
/* compose and send Ultrapeer Connection Request msg */
void UltraAgent::gnutella_req(Socket *sock) {
  PacketData *content;
  unsigned char *dataptr;
  char connstr[ULTRACONN_LEN];

  content = new PacketData(ULTRACONN_LEN-1);
  dataptr = content->data();
  strcpy((char *)connstr, ULTRA_CONN);
  memcpy(dataptr, connstr, ULTRACONN_LEN-1); 

  sock->send(ULTRACONN_LEN-1, content);
  
  if(conn_pending_.size()==1)
    conn_timer_.resched(CONN_TIMEOUT);
}

//=============================================================================
/* compose and send Gnutella Connection OK msg */
void UltraAgent::gnutella_ok(Socket *sock) {
  PacketData *content;
  unsigned char *dataptr;
  char connstr[ULTRAOK_LEN];

  content = new PacketData(ULTRAOK_LEN-1);
  dataptr = content->data();
  strcpy((char *)connstr, ULTRA_OK);
  memcpy(dataptr, connstr, ULTRAOK_LEN-1); 

  sock->send(ULTRAOK_LEN-1, content);
}

//=============================================================================
static class UltraAgentClass: public TclClass {
public:
  UltraAgentClass(): TclClass("SocketApp/PeerAgent/GnutellaAgent/UltraAgent") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new UltraAgent(atoi(argv[4])));
  }
}class_ultraagent;
//=============================================================================


