// File: gnut_util.h
// Original by Qi He
// Modified by Andre Dufour

#include "gnut_types.h"
#include "gnut_util.h"
#include "packet.h"

//=============================================================================
double
GnutUtil::
now(void)
{ 
    return Scheduler::instance().clock(); 
}
//=============================================================================
void
GnutUtil::
gnutError(char* format, ...)
{
    va_list ap;
  
    va_start(ap, format);
    vfprintf(stdout, format, ap);
    va_end(ap);
    fflush(NULL);
}

//=============================================================================
void
GnutUtil::
gnutTrace(char* format, ...)
{
#if 0
    va_list ap;
  
    va_start(ap, format);
    vfprintf(stdout, format, ap);
    va_end(ap);
    fflush(NULL);
#endif /* 0 */
}
//=============================================================================
void debug_info(char *format, ...) {
  va_list ap;
  
  if(getenv("GNUSIM_INFO")!=NULL) {
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);
  }
  fflush(NULL);
};
//=============================================================================
void debug_warning(char *format, ...) {
  va_list ap;
  
  if(getenv("GNUSIM_WARNING")!=NULL) {
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);
  }
  fflush(NULL);
};
//=============================================================================
void debug_stat(char *format, ...) {
  va_list ap;
  
  if(getenv("GNUSIM_NOSTAT")==NULL) {
    va_start(ap, format);
    vfprintf(stdout, format, ap);
    va_end(ap);
  }
  fflush(NULL);
};
//=============================================================================

