//=============================================================================
// File: gnutbinarymsgbc.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutbinarymsgbc.h"
#include <cstring>
#include "gnut_types.h"
#include "gnut_util.h"
#include "gnutmsgparser.h"

//=============================================================================
GnutBinaryMsgBC::
GnutBinaryMsgBC(DescriptorID_t aId, GnutMsgParser::EGnutMsgType aType, 
                Byte_t aTtl, Byte_t aHops, 
                const GnutCoord& aOriginatorCoord,
                double aOriginatorError)
: hdr_(aId, aType, aTtl, aHops),
  neighbourCoord_(aOriginatorCoord),
  neighbourError_(aOriginatorError),
  neighbourTimeSent_(GnutUtil::now()),
  originatorCoord_(aOriginatorCoord),
  originatorError_(aOriginatorError)
{ }
//=============================================================================
GnutBinaryMsgBC::
GnutBinaryMsgBC(const void* aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);

    memcpy(&hdr_, ptr, sizeof(hdr_));
    ptr += sizeof(hdr_);

    // Sanity check that enables us to use a little shortcut.
    static bool checked = false;
    if (checked == false)
    {
        GNUT_ASSERT(sizeof(double) == sizeof(neighbourCoord_.mX));
        checked = true;
    }

    const double* dblptr = reinterpret_cast<const double*>(ptr);

    const double x = *dblptr;
    dblptr++;

    const double y = *dblptr;
    dblptr++;
    
    const double height = *dblptr;
    dblptr++;

    neighbourCoord_ = GnutCoord(x, y, height);

    neighbourError_ = *dblptr;
    dblptr++;
    
    neighbourTimeSent_ = *dblptr;
    dblptr++;

    const double ox = *dblptr;
    dblptr++;

    const double oy = *dblptr;
    dblptr++;

    const double oheight = *dblptr;
    dblptr++;

    originatorCoord_ = GnutCoord(ox, oy, oheight);
    
    originatorError_ = *dblptr;
}
//=============================================================================
GnutBinaryMsgBC::
~GnutBinaryMsgBC(void)
{ }
//=============================================================================
void 
GnutBinaryMsgBC::
writeToPacket(void* aMem) const
{ 
    char* ptr = reinterpret_cast<char*>(aMem);

    memcpy(ptr, &hdr_, sizeof(hdr_));
    ptr += sizeof(hdr_);

    memcpy(ptr, &neighbourCoord_.mX, sizeof(neighbourCoord_.mX));
    ptr += sizeof(neighbourCoord_.mX);

    memcpy(ptr, &neighbourCoord_.mY, sizeof(neighbourCoord_.mY));
    ptr += sizeof(neighbourCoord_.mY);

    memcpy(ptr, &neighbourCoord_.mHeight, sizeof(neighbourCoord_.mHeight));
    ptr += sizeof(neighbourCoord_.mHeight);

    memcpy(ptr, &neighbourError_, sizeof(neighbourError_));
    ptr += sizeof(neighbourError_);

    memcpy(ptr, &neighbourTimeSent_, sizeof(neighbourTimeSent_));
    ptr += sizeof(neighbourTimeSent_);

    memcpy(ptr, &originatorCoord_.mX, sizeof(originatorCoord_.mX));
    ptr += sizeof(originatorCoord_.mX);

    memcpy(ptr, &originatorCoord_.mY, sizeof(originatorCoord_.mY));
    ptr += sizeof(originatorCoord_.mY);

    memcpy(ptr, &originatorCoord_.mHeight, sizeof(originatorCoord_.mHeight));
    ptr += sizeof(originatorCoord_.mHeight);

    memcpy(ptr, &originatorError_, sizeof(originatorError_));
}
//=============================================================================
size_t
GnutBinaryMsgBC::
getSize(void) const
{
    return sizeof(hdr_) + sizeof(neighbourCoord_.mX) 
         + sizeof(neighbourCoord_.mY) + sizeof(neighbourCoord_.mHeight) 
         + sizeof(neighbourError_) + sizeof(neighbourTimeSent_)
         + sizeof(originatorCoord_.mX) + sizeof(originatorCoord_.mY) 
         + sizeof(originatorCoord_.mHeight) + sizeof(originatorError_);
}
//=============================================================================

