//=============================================================================
// File: gnutbootcacheupdatemsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a bootcacheupdate message.
//=============================================================================

#ifndef __GNUTBOOTCACHEUPDATEMSG_H__
#define __GNUTBOOTCACHEUPDATEMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

class GnutCoord;

//=============================================================================
class GnutBootcacheUpdateMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input
    GnutBootcacheUpdateMsg(const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutBootcacheUpdateMsg(const void* aMem);

    virtual ~GnutBootcacheUpdateMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutBootcacheUpdateMsg(const GnutBootcacheUpdateMsg&);
    GnutBootcacheUpdateMsg& operator=(const GnutBootcacheUpdateMsg&);
};
//=============================================================================
#endif /* __GNUTBOOTCACHEUPDATEMSG_H__ */

