//=============================================================================
// File: gnutbootstrapmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a bootstrap message.
//=============================================================================


#ifndef __GNUTBOOTSTRAPMSG_H__
#define __GNUTBOOTSTRAPMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

class GnutCoord;

//=============================================================================
class GnutBootstrapMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input
    GnutBootstrapMsg(const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutBootstrapMsg(const void* aMem);

    virtual ~GnutBootstrapMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutBootstrapMsg(const GnutBootstrapMsg&);
    GnutBootstrapMsg& operator=(const GnutBootstrapMsg&);
};
//=============================================================================
#endif /* __GNUTBOOTSTRAPMSG_H__ */

