//=============================================================================
// File: gnutleafconnmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a leafconn message.
//=============================================================================

#ifndef __GNUTLEAFCONNMSG_H__
#define __GNUTLEAFCONNMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

class GnutCoord;

//=============================================================================
class GnutLeafConnMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutLeafConnMsg(const GnutCoord& aCoord, double aError);
    
    // Build structure from packet.
    GnutLeafConnMsg(const void* aMem);

    virtual ~GnutLeafConnMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutLeafConnMsg(const GnutLeafConnMsg&);
    GnutLeafConnMsg& operator=(const GnutLeafConnMsg&);
};
//=============================================================================
#endif /* __GNUTLEAFCONNMSG_H__ */

