//=============================================================================
// File: gnutlegacyconnectmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a legacyconnect message.
//=============================================================================

#ifndef __GNUTLEGACYCONNECTMSG_H__
#define __GNUTLEGACYCONNECTMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

class GnutCoord;

//=============================================================================
class GnutLegacyConnectMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutLegacyConnectMsg(const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutLegacyConnectMsg(const void* aMem);

    virtual ~GnutLegacyConnectMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutLegacyConnectMsg(const GnutLegacyConnectMsg&);
    GnutLegacyConnectMsg& operator=(const GnutLegacyConnectMsg&);
};
//=============================================================================
#endif /* __GNUTLEGACYCONNECTMSG_H__ */

