//=============================================================================
// File: gnutpayload.h
// Author: Andre Dufour
//
// Class type: union
// Description: container for gnutella message payloads
//=============================================================================

#ifndef __GNUTPAYLOAD_H__
#define __GNUTPAYLOAD_H__

#include "gnutbootstrapresmsg.h"
#include "gnutpongmsg.h"

//============================================================================
union GnutPayload
{
public:
    // = FOUNDATION

    GnutPayload(void);
    GnutPayload(const BootstrapRes& aRes);
    GnutPayload(const PongRes& aRes);
    ~GnutPayload(void);


    // = ACCESS

    const BootstrapRes& getBootstrapRes(void) const;
    const PongRes& getPongRes(void) const;


    // = ACTION

    // IMPORTANT: any previous results must be freed before
    // calling these next two methods
    void setBootstrapRes(const BootstrapRes& aRes);
    void setPongRes(const PongRes& aRes);

    // One of these must be called before the object is destroyed in order
    // to avoid memory leaks. Be sure to call the right one.
    void freeBootstrapRes(void);
    void freePongRes(void);

        
private:
    // = DATA

    BootstrapRes*   bootstrap_res_;
    PongRes*        pong_res_;


    // = FOUNDATION

    GnutPayload(const GnutPayload&);
    GnutPayload& operator=(const GnutPayload&);
};
//=============================================================================
#endif /* __GNUTPAYLOAD_H__ */

