//=============================================================================
// File: gnutquerymsg.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutquerymsg.h"
#include "gnutmsgparser.h"
#include "gnut_types.h"
#include "gnut_util.h"

//=============================================================================
GnutQueryMsg::
GnutQueryMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops,
             const GnutCoord& aCoord, double aError)
: GnutBinaryMsgBC(aId, GnutMsgParser::GNUT_QUERY, aTtl, aHops,
                  aCoord, aError),
  timeQuerySent_(GnutUtil::now())
{ }
//=============================================================================
GnutQueryMsg::
GnutQueryMsg(const void* aMem)
: GnutBinaryMsgBC(aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);
    ptr += GnutBinaryMsgBC::getSize();
    memcpy(&timeQuerySent_, ptr, sizeof(timeQuerySent_));
}
//=============================================================================
GnutQueryMsg::
~GnutQueryMsg(void)
{ }
//=============================================================================
void 
GnutQueryMsg::
writeToPacket(void* aMem) const
{ 
    GnutBinaryMsgBC::writeToPacket(aMem);

    char* ptr = reinterpret_cast<char*>(aMem);
    ptr += GnutBinaryMsgBC::getSize();
    memcpy(ptr, &timeQuerySent_, sizeof(timeQuerySent_));
}
//=============================================================================
size_t
GnutQueryMsg::
getSize(void) const
{
    return GnutBinaryMsgBC::getSize() + sizeof(timeQuerySent_);
}
//=============================================================================

