//=============================================================================
// File: gnutultraleafdirmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a ultraok leaf direction
//              message.
//=============================================================================

#ifndef __GNUTULTRALEAFDIRMSG_H__
#define __GNUTULTRALEAFDIRMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

class GnutCoord;

//=============================================================================
class GnutUltraLeafDirMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutUltraLeafDirMsg(const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutUltraLeafDirMsg(const void* aMem);

    virtual ~GnutUltraLeafDirMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutUltraLeafDirMsg(const GnutUltraLeafDirMsg&);
    GnutUltraLeafDirMsg& operator=(const GnutUltraLeafDirMsg&);
};
//=============================================================================
#endif /* __GNUTULTRALEAFDIRMSG_H__ */

