//=============================================================================
// File: ivivaldimanager.h
// Author: Andre Dufour
//
// Class type: interface
// Description: Interface for implementation of Vivaldi coordinate
//              system.
//=============================================================================

#ifndef __IVIVALDIMANAGER_H__
#define __IVIVALDIMANAGER_H__

#include "gnutcoord.h"

class IVivaldiManager
{
    // = FOUNDATION

protected:
    IVivaldiManager(void);
public:
    virtual ~IVivaldiManager(void);


    // = CONSTANTS

    static const double NEW_NODE_ERROR;
    

    // = ACCESS

    virtual GnutCoord getCoordinates(void) const = 0;

    virtual void updateCoordinates(
            const GnutCoord& aRemoteCoord,
            double aRtt,
            double aRemoteError) = 0;
    // Update this nodes's coordinates based on the RTT measurement
    // to the other node.

    virtual void resetCoordinates(void) = 0;
    // Reset this node's coordinates to the initial ones.
    // This will normally correspond to the origin)

    virtual double getLocalError(void) const = 0;
    // Return the local error on this node's coordinates.

    virtual double estimateRtt(const GnutCoord& aRemoteCoord) const = 0;
    // Profice an estimate of the RTT based on this node's coordinates
    // and the remote node's coordinates. The caller should consider the
    // local and remote errors before relying too heavily on this estimate.

private:

    // = FOUNDATION

    // Disable copy constructor and assignment operator
    IVivaldiManager(const IVivaldiManager&);
    IVivaldiManager& operator=(const IVivaldiManager&);

};
//=============================================================================
#endif /* __IVIVALDIMANAGER_H__ */

