// File: leaf.cc
// Original by Qi He
// Modified by Andre Dufour

#include "leaf.h"
#include "gnut_types.h"
#include "gnut_util.h"
#include "smpbootserver.h"
#include "gnutellaapp.h"
#include "gnutellaagent.h"
#include "gnutbootstrapresmsg.h"
#include "gnuthierapp.h"
#include "gnutstats.h"

//=============================================================================
/* Leaf Application */
Leaf::
Leaf(NodeAddr_t aAddr, const char* const aParent, int aUsesVivaldi) 
: GnutellaApp(aAddr, aParent, aUsesVivaldi, 0.0)
{ 
    GnutUtil::gnutTrace("Creating leaf %p for node %d.\n", this, aAddr);
}
//=============================================================================
Leaf::
~Leaf(void)
{ 
    // TODO: AD
    GnutUtil::gnutTrace("Destroying leaf %d\n", addr_);
}
//=============================================================================
void 
Leaf::
bootstrap() 
{
    if(smpBoot_) 
    {
        BootstrapRes* res = bootSrv_->BootstrapRequest(this->addr_, this, EPeerLeaf);

        if (res != 0)
        {
            BootstrapResult(res->cnt_, res->servents_);

            delete res;
        }
    } 
    else 
    {
        GnutellaApp::bootstrap();
    }
}
//=============================================================================
bool 
Leaf::
avail(EPeerType) const
{
    return false;
}
//=============================================================================
void 
Leaf::
disconnect(NodeAddr_t addr) 
{
    gagent_->Disconnect(addr);
    if(addr == GnutellaAgent::ALL_NEIGHBOURS) 
    {
        lpeers_.clear();
        mPeerDistances.clear();
    }
    else 
    {
        PeerMap_t::iterator pi = lpeers_.find(addr);
        if(pi!=lpeers_.end()) 
        {
            lpeers_.erase(pi);

            PeerDistances::iterator diter = mPeerDistances.find(addr);
            GNUT_ASSERT(diter != mPeerDistances.end());
            mPeerDistances.erase(diter);
        }
    }
    degree_.increment(lpeers_.size());
    mGnutStats.setPeerConns(addr_, lpeers_.size());
}
//=============================================================================
int
Leaf::
connectUpeer(NodeAddr_t aAddr)
{
    // A bit of fakery to get this leaf to connect to a particular
    // ultrapeer.
    NodeAddr_t bsr = aAddr;
    BootstrapResult(1, &bsr);
    return TCL_OK;
}
//=============================================================================
int 
Leaf::
command(int argc, const char*const* argv)
{
    if (argc == 3 && strcmp("connect-upeer", argv[1]) == 0)
    {
        return connectUpeer(atoi(argv[2]));
    }
    else
    {
        return GnutellaApp::command(argc, argv);
    }
}
//=============================================================================
static class LeafClass: public TclClass 
{
public:
    LeafClass(): TclClass("PeerApp/GnutellaApp/Leaf") {}
    TclObject* create(int argc, const char*const* argv) 
    {
        return (new Leaf(atoi(argv[4]), argv[5], atoi(argv[6])));
    }
} class_leaf;
//=============================================================================

