#ifndef __NS_SOCKET_H
#define __NS_SOCKET_H

#include "node.h"
#include "packet.h"
#include "tcp-sock.h"
#include "ip.h"

#define UNCONNECTED 0
#define CONNECTING 1
#define CONNECTED 2
#define BLOCKED 3
#define CLOSING 4

#define ENOTCONN 1
#define EWOULDBLOCK 2

#define SOCK_WRITE 0
#define SOCK_READ 1


#ifdef PDNS
typedef ipaddr_t NodeAddr_t;
typedef ipportaddr_t Port_t;
#else
typedef nsaddr_t NodeAddr_t;
typedef nsaddr_t Port_t;
#endif

class SocketApp;

typedef struct {
  NodeAddr_t addr_;
  Port_t port_;
} SockAddr_t;

class NSSocket: public AdvwTcpApplication {
 public:
  NSSocket();
  virtual ~NSSocket();
  
  SocketApp *app_;
  void connect(NodeAddr_t, Port_t); 
  virtual int send(int len, PacketData *data);
  void _bind(NodeAddr_t, Port_t);
  virtual void recv();
  int blocked(int op);
  void connect();

  int state_;
  int errno_;
  SockAddr_t peer_;
  int sec_;
  int secRcv_;
  int rate_limit_;
  int isPrio_;

  virtual void upcall_send();
  virtual int upcall_recv(PacketData *);
  void upcall_connected(Packet *);
  void upcall_passconn();
  void upcall_closing();
  NodeAddr_t addr_;
  Port_t port_;
  void upcall_accept(Packet *);
  void listen(int max);
  void close();
  NodeAddr_t daddr() {return agent_->daddr();}
  Port_t dport() {return agent_->dport();}

 protected:
  int command(int argc, const char*const* argv);
};

typedef NSSocket Socket;

class SocketApp: public TclObject {
 public:
  SocketApp();
  virtual ~SocketApp();

  virtual int upcall_recv(Socket *, PacketData *, Handler *);
  virtual void upcall_connected(Socket *);
  virtual void upcall_passconn(Socket *);
  virtual void upcall_closing(Socket *);
  virtual void upcall_send(Socket *);
};


#endif
