// Original by Qi He
// Modified by Andre Dufour

#ifndef __PEERAGENT_H__
#define __PEERAGENT_H__

#include "gnut_types.h"

#ifdef GTNETS
class PeerAgent: public Application 
{
#else
class PeerAgent: public SocketApp 
{
#endif
public:
    // = FOUNDATION

    PeerAgent(PeerApp* aApp);
    PeerAgent(NodeAddr_t aAddr);
    virtual ~PeerAgent(void);


    // = ACTION

    //upcalls from Socket
    virtual int upcall_recv(Socket* , PacketData* , Handler* );
    virtual void upcall_connected(Socket* );
    virtual void upcall_passconn(Socket* );
    virtual void upcall_closing(Socket* );
    virtual void upcall_send(Socket* );


public:
    // = DATA

    PeerApp* app_;
    SockMap_t lsocks_; //list of active sockets

private:
    // = FOUNDATION

    PeerAgent(const PeerAgent&);
    PeerAgent operator=(const PeerAgent&);
};


#endif /* __PEERAGENT_H__ */

