# Script demonstrating the use of GnutellaSim in ns2
# Q. He (08/01/2003)

# Generated by sgb2ns, created by Polly Huang
# GRAPH (#nodes #edges id uu vv ww xx yy zz):
# 100 374 transtub(0,3,0,0,{1,89,3,0.500,1.000,0.100},{4,44,3,0.600,1.000,0.100},{8,36,3,0.420,1.000,0.100}) 89 2 5 0 
proc create-topology {nsns node leaf qSize} {
	upvar $node n
	upvar $nsns ns
	upvar $leaf nl
	global cnt

	set verbose 1

	if {$verbose} { 
		puts "creating nodes..." 
	}

	set rng [new RNG]
	$rng seed 0
	# create physical nodes and attach to the GT-ITM TS topology as leaves
	set cnt 0
	for {set i 0} {$i < 100} {incr i} {
		set n($i) [$ns node]
		set nleaf [$rng uniform 4 8]

		for {set j 0} {$j < $nleaf} {incr j} {

			# access bandwidth follows statistics from previous 
			# measurement results
			set pcap [$rng uniform 0 10]
			if {$pcap < 1 } {
				set cap "100Mb"
			} 
			if {$pcap >=1 && $pcap < 3 } {
				set cap "10Mb"
			}
			if {$pcap >=3 && $pcap < 8 } {
				set cap "1.5Mb"
			}
			if {$pcap >=8 } {
				set cap "56Kb"
			} 
			 
			set nl($cnt) [$ns node]
			set delay [$rng uniform 10 80] ; #random delay
			set ndelay ${delay}ms
			$ns duplex-link $n($i) $nl($cnt) $cap $ndelay DropTail
			incr cnt	
		}
	}

	puts "total leaf count $cnt"

	# GT-ITM Transit-Stub Topo
	# EDGES (from-node to-node length a b):
	if {$verbose} { 
		puts -nonewline "Creating links 0..."
		flush stdout 
	}
	$ns duplex-link $n(0) $n(29) 155M 315ms DropTail
	$ns queue-limit $n(0) $n(29) 50
	$ns duplex-link $n(0) $n(17) 155M 238ms DropTail
	$ns queue-limit $n(0) $n(17) 50
	$ns duplex-link $n(0) $n(12) 1.5M 168ms DropTail
	$ns queue-limit $n(0) $n(12) 50
	$ns duplex-link $n(0) $n(4) 155M 308ms DropTail
	$ns queue-limit $n(0) $n(4) 50
	$ns duplex-link $n(0) $n(2) 155M 448ms DropTail
	$ns queue-limit $n(0) $n(2) 50
	$ns duplex-link $n(0) $n(3) 155M 245ms DropTail
	$ns queue-limit $n(0) $n(3) 50
	$ns duplex-link $n(1) $n(63) 45M 28ms DropTail
	$ns queue-limit $n(1) $n(63) 50
	$ns duplex-link $n(1) $n(53) 45M 280ms DropTail
	$ns queue-limit $n(1) $n(53) 50
	$ns duplex-link $n(1) $n(44) 155M 7ms DropTail
	$ns queue-limit $n(1) $n(44) 50
	$ns duplex-link $n(1) $n(40) 155M 294ms DropTail
	$ns queue-limit $n(1) $n(40) 50
	if {$verbose} { puts -nonewline "10..."; flush stdout }
	$ns duplex-link $n(1) $n(2) 155M 119ms DropTail
	$ns queue-limit $n(1) $n(2) 50
	$ns duplex-link $n(1) $n(3) 155M 189ms DropTail
	$ns queue-limit $n(1) $n(3) 50
	$ns duplex-link $n(2) $n(88) 1.5M 224ms DropTail
	$ns queue-limit $n(2) $n(88) 50
	$ns duplex-link $n(2) $n(80) 1.5M 154ms DropTail
	$ns queue-limit $n(2) $n(80) 50
	$ns duplex-link $n(2) $n(69) 1.5M 77ms DropTail
	$ns queue-limit $n(2) $n(69) 50
	$ns duplex-link $n(2) $n(3) 155M 210ms DropTail
	$ns queue-limit $n(2) $n(3) 50
	$ns duplex-link $n(3) $n(95) 45M 189ms DropTail
	$ns queue-limit $n(3) $n(95) 50
	$ns duplex-link $n(4) $n(5) 45M 84ms DropTail
	$ns queue-limit $n(4) $n(5) 50
	$ns duplex-link $n(4) $n(7) 1.5M 224ms DropTail
	$ns queue-limit $n(4) $n(7) 50
	$ns duplex-link $n(5) $n(6) 10M 154ms DropTail
	$ns queue-limit $n(5) $n(6) 50
	if {$verbose} { puts -nonewline "20..."; flush stdout }
	$ns duplex-link $n(6) $n(7) 10M 175ms DropTail
	$ns queue-limit $n(6) $n(7) 50
	$ns duplex-link $n(8) $n(9) 1.5M 168ms DropTail
	$ns queue-limit $n(8) $n(9) 50
	$ns duplex-link $n(8) $n(11) 1.5M 98ms DropTail
	$ns queue-limit $n(8) $n(11) 50
	$ns duplex-link $n(9) $n(10) 10M 210ms DropTail
	$ns queue-limit $n(9) $n(10) 50
	$ns duplex-link $n(9) $n(12) 1.5M 56ms DropTail
	$ns queue-limit $n(9) $n(12) 50
	$ns duplex-link $n(10) $n(12) 10M 245ms DropTail
	$ns queue-limit $n(10) $n(12) 50
	$ns duplex-link $n(10) $n(15) 1.5M 315ms DropTail
	$ns queue-limit $n(10) $n(15) 50
	$ns duplex-link $n(11) $n(12) 1.5M 168ms DropTail
	$ns queue-limit $n(11) $n(12) 50
	$ns duplex-link $n(11) $n(13) 1.5M 168ms DropTail
	$ns queue-limit $n(11) $n(13) 50
	$ns duplex-link $n(11) $n(15) 1.5M 224ms DropTail
	$ns queue-limit $n(11) $n(15) 50
	if {$verbose} { puts -nonewline "30..."; flush stdout }
	$ns duplex-link $n(12) $n(13) 1.5M 7ms DropTail
	$ns queue-limit $n(12) $n(13) 50
	$ns duplex-link $n(12) $n(14) 1.5M 147ms DropTail
	$ns queue-limit $n(12) $n(14) 50
	$ns duplex-link $n(12) $n(15) 10M 56ms DropTail
	$ns queue-limit $n(12) $n(15) 50
	$ns duplex-link $n(13) $n(14) 1.5M 140ms DropTail
	$ns queue-limit $n(13) $n(14) 50
	$ns duplex-link $n(16) $n(18) 1.5M 126ms DropTail
	$ns queue-limit $n(16) $n(18) 50
	$ns duplex-link $n(16) $n(20) 1.5M 154ms DropTail
	$ns queue-limit $n(16) $n(20) 50
	$ns duplex-link $n(16) $n(25) 1.5M 175ms DropTail
	$ns queue-limit $n(16) $n(25) 50
	$ns duplex-link $n(17) $n(20) 1.5M 154ms DropTail
	$ns queue-limit $n(17) $n(20) 50
	$ns duplex-link $n(17) $n(23) 1.5M 189ms DropTail
	$ns queue-limit $n(17) $n(23) 50
	$ns duplex-link $n(17) $n(24) 10M 77ms DropTail
	$ns queue-limit $n(17) $n(24) 50
	if {$verbose} { puts -nonewline "40..."; flush stdout }
	$ns duplex-link $n(17) $n(25) 1.5M 154ms DropTail
	$ns queue-limit $n(17) $n(25) 50
	$ns duplex-link $n(17) $n(26) 1.5M 168ms DropTail
	$ns queue-limit $n(17) $n(26) 50
	$ns duplex-link $n(18) $n(19) 1.5M 154ms DropTail
	$ns queue-limit $n(18) $n(19) 50
	$ns duplex-link $n(18) $n(21) 1.5M 168ms DropTail
	$ns queue-limit $n(18) $n(21) 50
	$ns duplex-link $n(18) $n(22) 1.5M 315ms DropTail
	$ns queue-limit $n(18) $n(22) 50
	$ns duplex-link $n(18) $n(24) 1.5M 217ms DropTail
	$ns queue-limit $n(18) $n(24) 50
	$ns duplex-link $n(18) $n(26) 1.5M 336ms DropTail
	$ns queue-limit $n(18) $n(26) 50
	$ns duplex-link $n(19) $n(20) 1.5M 168ms DropTail
	$ns queue-limit $n(19) $n(20) 50
	$ns duplex-link $n(19) $n(21) 1.5M 126ms DropTail
	$ns queue-limit $n(19) $n(21) 50
	$ns duplex-link $n(19) $n(22) 1.5M 189ms DropTail
	$ns queue-limit $n(19) $n(22) 50
	if {$verbose} { puts -nonewline "50..."; flush stdout }
	$ns duplex-link $n(19) $n(23) 1.5M 196ms DropTail
	$ns queue-limit $n(19) $n(23) 50
	$ns duplex-link $n(19) $n(24) 10M 84ms DropTail
	$ns queue-limit $n(19) $n(24) 50
	$ns duplex-link $n(19) $n(25) 1.5M 168ms DropTail
	$ns queue-limit $n(19) $n(25) 50
	$ns duplex-link $n(20) $n(21) 1.5M 105ms DropTail
	$ns queue-limit $n(20) $n(21) 50
	$ns duplex-link $n(20) $n(22) 1.5M 56ms DropTail
	$ns queue-limit $n(20) $n(22) 50
	$ns duplex-link $n(20) $n(23) 1.5M 189ms DropTail
	$ns queue-limit $n(20) $n(23) 50
	$ns duplex-link $n(20) $n(25) 1.5M 28ms DropTail
	$ns queue-limit $n(20) $n(25) 50
	$ns duplex-link $n(20) $n(26) 1.5M 210ms DropTail
	$ns queue-limit $n(20) $n(26) 50
	$ns duplex-link $n(22) $n(24) 1.5M 98ms DropTail
	$ns queue-limit $n(22) $n(24) 50
	$ns duplex-link $n(23) $n(24) 1.5M 189ms DropTail
	$ns queue-limit $n(23) $n(24) 50
	if {$verbose} { puts -nonewline "60..."; flush stdout }
	$ns duplex-link $n(23) $n(26) 1.5M 336ms DropTail
	$ns queue-limit $n(23) $n(26) 50
	$ns duplex-link $n(24) $n(26) 10M 147ms DropTail
	$ns queue-limit $n(24) $n(26) 50
	$ns duplex-link $n(27) $n(30) 1.5M 217ms DropTail
	$ns queue-limit $n(27) $n(30) 50
	$ns duplex-link $n(27) $n(32) 1.5M 168ms DropTail
	$ns queue-limit $n(27) $n(32) 50
	$ns duplex-link $n(27) $n(34) 1.5M 105ms DropTail
	$ns queue-limit $n(27) $n(34) 50
	$ns duplex-link $n(27) $n(35) 10M 77ms DropTail
	$ns queue-limit $n(27) $n(35) 50
	$ns duplex-link $n(28) $n(31) 1.5M 224ms DropTail
	$ns queue-limit $n(28) $n(31) 50
	$ns duplex-link $n(28) $n(33) 1.5M 196ms DropTail
	$ns queue-limit $n(28) $n(33) 50
	$ns duplex-link $n(29) $n(30) 1.5M 329ms DropTail
	$ns queue-limit $n(29) $n(30) 50
	$ns duplex-link $n(29) $n(33) 1.5M 98ms DropTail
	$ns queue-limit $n(29) $n(33) 50
	if {$verbose} { puts -nonewline "70..."; flush stdout }
	$ns duplex-link $n(29) $n(34) 1.5M 189ms DropTail
	$ns queue-limit $n(29) $n(34) 50
	$ns duplex-link $n(30) $n(34) 1.5M 315ms DropTail
	$ns queue-limit $n(30) $n(34) 50
	$ns duplex-link $n(30) $n(35) 1.5M 294ms DropTail
	$ns queue-limit $n(30) $n(35) 50
	$ns duplex-link $n(31) $n(33) 10M 28ms DropTail
	$ns queue-limit $n(31) $n(33) 50
	$ns duplex-link $n(32) $n(33) 1.5M 84ms DropTail
	$ns queue-limit $n(32) $n(33) 50
	$ns duplex-link $n(32) $n(35) 10M 245ms DropTail
	$ns queue-limit $n(32) $n(35) 50
	$ns duplex-link $n(33) $n(35) 1.5M 224ms DropTail
	$ns queue-limit $n(33) $n(35) 50
	$ns duplex-link $n(36) $n(38) 1.5M 245ms DropTail
	$ns queue-limit $n(36) $n(38) 50
	$ns duplex-link $n(36) $n(41) 1.5M 77ms DropTail
	$ns queue-limit $n(36) $n(41) 50
	$ns duplex-link $n(37) $n(40) 1.5M 7ms DropTail
	$ns queue-limit $n(37) $n(40) 50
	if {$verbose} { puts -nonewline "80..."; flush stdout }
	$ns duplex-link $n(37) $n(41) 1.5M 280ms DropTail
	$ns queue-limit $n(37) $n(41) 50
	$ns duplex-link $n(38) $n(39) 1.5M 147ms DropTail
	$ns queue-limit $n(38) $n(39) 50
	$ns duplex-link $n(38) $n(40) 1.5M 7ms DropTail
	$ns queue-limit $n(38) $n(40) 50
	$ns duplex-link $n(42) $n(43) 10M 189ms DropTail
	$ns queue-limit $n(42) $n(43) 50
	$ns duplex-link $n(42) $n(44) 1.5M 98ms DropTail
	$ns queue-limit $n(42) $n(44) 50
	$ns duplex-link $n(42) $n(45) 1.5M 77ms DropTail
	$ns queue-limit $n(42) $n(45) 50
	$ns duplex-link $n(43) $n(44) 1.5M 140ms DropTail
	$ns queue-limit $n(43) $n(44) 50
	$ns duplex-link $n(43) $n(47) 10M 105ms DropTail
	$ns queue-limit $n(43) $n(47) 50
	$ns duplex-link $n(43) $n(48) 10M 147ms DropTail
	$ns queue-limit $n(43) $n(48) 50
	$ns duplex-link $n(44) $n(45) 1.5M 105ms DropTail
	$ns queue-limit $n(44) $n(45) 50
	if {$verbose} { puts -nonewline "90..."; flush stdout }
	$ns duplex-link $n(45) $n(46) 1.5M 308ms DropTail
	$ns queue-limit $n(45) $n(46) 50
	$ns duplex-link $n(45) $n(47) 1.5M 105ms DropTail
	$ns queue-limit $n(45) $n(47) 50
	$ns duplex-link $n(46) $n(48) 1.5M 175ms DropTail
	$ns queue-limit $n(46) $n(48) 50
	$ns duplex-link $n(47) $n(48) 1.5M 49ms DropTail
	$ns queue-limit $n(47) $n(48) 50
	$ns duplex-link $n(49) $n(53) 1.5M 350ms DropTail
	$ns queue-limit $n(49) $n(53) 50
	$ns duplex-link $n(49) $n(58) 1.5M 350ms DropTail
	$ns queue-limit $n(49) $n(58) 50
	$ns duplex-link $n(50) $n(52) 1.5M 210ms DropTail
	$ns queue-limit $n(50) $n(52) 50
	$ns duplex-link $n(50) $n(56) 1.5M 245ms DropTail
	$ns queue-limit $n(50) $n(56) 50
	$ns duplex-link $n(51) $n(53) 1.5M 217ms DropTail
	$ns queue-limit $n(51) $n(53) 50
	$ns duplex-link $n(51) $n(56) 1.5M 224ms DropTail
	$ns queue-limit $n(51) $n(56) 50
	if {$verbose} { puts -nonewline "100..."; flush stdout }
	$ns duplex-link $n(51) $n(57) 1.5M 280ms DropTail
	$ns queue-limit $n(51) $n(57) 50
	$ns duplex-link $n(51) $n(58) 1.5M 168ms DropTail
	$ns queue-limit $n(51) $n(58) 50
	$ns duplex-link $n(52) $n(54) 1.5M 7ms DropTail
	$ns queue-limit $n(52) $n(54) 50
	$ns duplex-link $n(52) $n(56) 1.5M 175ms DropTail
	$ns queue-limit $n(52) $n(56) 50
	$ns duplex-link $n(52) $n(58) 1.5M 105ms DropTail
	$ns queue-limit $n(52) $n(58) 50
	$ns duplex-link $n(53) $n(54) 1.5M 77ms DropTail
	$ns queue-limit $n(53) $n(54) 50
	$ns duplex-link $n(53) $n(55) 1.5M 259ms DropTail
	$ns queue-limit $n(53) $n(55) 50
	$ns duplex-link $n(53) $n(58) 1.5M 70ms DropTail
	$ns queue-limit $n(53) $n(58) 50
	$ns duplex-link $n(54) $n(55) 1.5M 175ms DropTail
	$ns queue-limit $n(54) $n(55) 50
	$ns duplex-link $n(54) $n(58) 10M 119ms DropTail
	$ns queue-limit $n(54) $n(58) 50
	if {$verbose} { puts -nonewline "110..."; flush stdout }
	$ns duplex-link $n(55) $n(58) 10M 294ms DropTail
	$ns queue-limit $n(55) $n(58) 50
	$ns duplex-link $n(56) $n(57) 1.5M 49ms DropTail
	$ns queue-limit $n(56) $n(57) 50
	$ns duplex-link $n(56) $n(58) 1.5M 245ms DropTail
	$ns queue-limit $n(56) $n(58) 50
	$ns duplex-link $n(59) $n(60) 10M 175ms DropTail
	$ns queue-limit $n(59) $n(60) 50
	$ns duplex-link $n(59) $n(61) 1.5M 77ms DropTail
	$ns queue-limit $n(59) $n(61) 50
	$ns duplex-link $n(59) $n(63) 1.5M 28ms DropTail
	$ns queue-limit $n(59) $n(63) 50
	$ns duplex-link $n(60) $n(63) 1.5M 189ms DropTail
	$ns queue-limit $n(60) $n(63) 50
	$ns duplex-link $n(60) $n(66) 1.5M 140ms DropTail
	$ns queue-limit $n(60) $n(66) 50
	$ns duplex-link $n(60) $n(67) 1.5M 126ms DropTail
	$ns queue-limit $n(60) $n(67) 50
	$ns duplex-link $n(61) $n(63) 1.5M 70ms DropTail
	$ns queue-limit $n(61) $n(63) 50
	if {$verbose} { puts -nonewline "120..."; flush stdout }
	$ns duplex-link $n(61) $n(64) 1.5M 28ms DropTail
	$ns queue-limit $n(61) $n(64) 50
	$ns duplex-link $n(61) $n(67) 1.5M 140ms DropTail
	$ns queue-limit $n(61) $n(67) 50
	$ns duplex-link $n(62) $n(64) 10M 98ms DropTail
	$ns queue-limit $n(62) $n(64) 50
	$ns duplex-link $n(62) $n(67) 1.5M 175ms DropTail
	$ns queue-limit $n(62) $n(67) 50
	$ns duplex-link $n(63) $n(65) 1.5M 119ms DropTail
	$ns queue-limit $n(63) $n(65) 50
	$ns duplex-link $n(63) $n(66) 10M 217ms DropTail
	$ns queue-limit $n(63) $n(66) 50
	$ns duplex-link $n(63) $n(67) 10M 77ms DropTail
	$ns queue-limit $n(63) $n(67) 50
	$ns duplex-link $n(65) $n(67) 1.5M 56ms DropTail
	$ns queue-limit $n(65) $n(67) 50
	$ns duplex-link $n(66) $n(67) 10M 210ms DropTail
	$ns queue-limit $n(66) $n(67) 50
	$ns duplex-link $n(68) $n(72) 1.5M 315ms DropTail
	$ns queue-limit $n(68) $n(72) 50
	if {$verbose} { puts -nonewline "130..."; flush stdout }
	$ns duplex-link $n(68) $n(74) 10M 70ms DropTail
	$ns queue-limit $n(68) $n(74) 50
	$ns duplex-link $n(69) $n(70) 1.5M 98ms DropTail
	$ns queue-limit $n(69) $n(70) 50
	$ns duplex-link $n(69) $n(71) 1.5M 70ms DropTail
	$ns queue-limit $n(69) $n(71) 50
	$ns duplex-link $n(69) $n(75) 1.5M 217ms DropTail
	$ns queue-limit $n(69) $n(75) 50
	$ns duplex-link $n(70) $n(71) 10M 49ms DropTail
	$ns queue-limit $n(70) $n(71) 50
	$ns duplex-link $n(70) $n(73) 1.5M 238ms DropTail
	$ns queue-limit $n(70) $n(73) 50
	$ns duplex-link $n(70) $n(76) 1.5M 217ms DropTail
	$ns queue-limit $n(70) $n(76) 50
	$ns duplex-link $n(71) $n(73) 1.5M 189ms DropTail
	$ns queue-limit $n(71) $n(73) 50
	$ns duplex-link $n(71) $n(75) 10M 217ms DropTail
	$ns queue-limit $n(71) $n(75) 50
	$ns duplex-link $n(71) $n(76) 1.5M 175ms DropTail
	$ns queue-limit $n(71) $n(76) 50
	if {$verbose} { puts -nonewline "140..."; flush stdout }
	$ns duplex-link $n(73) $n(74) 1.5M 238ms DropTail
	$ns queue-limit $n(73) $n(74) 50
	$ns duplex-link $n(73) $n(75) 1.5M 35ms DropTail
	$ns queue-limit $n(73) $n(75) 50
	$ns duplex-link $n(74) $n(76) 1.5M 259ms DropTail
	$ns queue-limit $n(74) $n(76) 50
	$ns duplex-link $n(75) $n(76) 10M 189ms DropTail
	$ns queue-limit $n(75) $n(76) 50
	$ns duplex-link $n(77) $n(79) 1.5M 98ms DropTail
	$ns queue-limit $n(77) $n(79) 50
	$ns duplex-link $n(77) $n(82) 1.5M 210ms DropTail
	$ns queue-limit $n(77) $n(82) 50
	$ns duplex-link $n(78) $n(79) 1.5M 245ms DropTail
	$ns queue-limit $n(78) $n(79) 50
	$ns duplex-link $n(78) $n(81) 1.5M 147ms DropTail
	$ns queue-limit $n(78) $n(81) 50
	$ns duplex-link $n(78) $n(83) 1.5M 238ms DropTail
	$ns queue-limit $n(78) $n(83) 50
	$ns duplex-link $n(78) $n(85) 10M 217ms DropTail
	$ns queue-limit $n(78) $n(85) 50
	if {$verbose} { puts -nonewline "150..."; flush stdout }
	$ns duplex-link $n(78) $n(86) 1.5M 70ms DropTail
	$ns queue-limit $n(78) $n(86) 50
	$ns duplex-link $n(79) $n(83) 1.5M 98ms DropTail
	$ns queue-limit $n(79) $n(83) 50
	$ns duplex-link $n(79) $n(86) 10M 217ms DropTail
	$ns queue-limit $n(79) $n(86) 50
	$ns duplex-link $n(80) $n(84) 1.5M 308ms DropTail
	$ns queue-limit $n(80) $n(84) 50
	$ns duplex-link $n(80) $n(85) 1.5M 336ms DropTail
	$ns queue-limit $n(80) $n(85) 50
	$ns duplex-link $n(81) $n(82) 1.5M 126ms DropTail
	$ns queue-limit $n(81) $n(82) 50
	$ns duplex-link $n(81) $n(84) 1.5M 224ms DropTail
	$ns queue-limit $n(81) $n(84) 50
	$ns duplex-link $n(82) $n(83) 1.5M 259ms DropTail
	$ns queue-limit $n(82) $n(83) 50
	$ns duplex-link $n(82) $n(84) 10M 294ms DropTail
	$ns queue-limit $n(82) $n(84) 50
	$ns duplex-link $n(82) $n(85) 10M 266ms DropTail
	$ns queue-limit $n(82) $n(85) 50
	if {$verbose} { puts -nonewline "160..."; flush stdout }
	$ns duplex-link $n(82) $n(86) 1.5M 224ms DropTail
	$ns queue-limit $n(82) $n(86) 50
	$ns duplex-link $n(83) $n(85) 1.5M 35ms DropTail
	$ns queue-limit $n(83) $n(85) 50
	$ns duplex-link $n(83) $n(86) 10M 189ms DropTail
	$ns queue-limit $n(83) $n(86) 50
	$ns duplex-link $n(84) $n(85) 1.5M 245ms DropTail
	$ns queue-limit $n(84) $n(85) 50
	$ns duplex-link $n(84) $n(86) 1.5M 98ms DropTail
	$ns queue-limit $n(84) $n(86) 50
	$ns duplex-link $n(85) $n(86) 1.5M 154ms DropTail
	$ns queue-limit $n(85) $n(86) 50
	$ns duplex-link $n(87) $n(88) 1.5M 56ms DropTail
	$ns queue-limit $n(87) $n(88) 50
	$ns duplex-link $n(87) $n(89) 1.5M 175ms DropTail
	$ns queue-limit $n(87) $n(89) 50
	$ns duplex-link $n(87) $n(90) 1.5M 70ms DropTail
	$ns queue-limit $n(87) $n(90) 50
	$ns duplex-link $n(87) $n(91) 1.5M 210ms DropTail
	$ns queue-limit $n(87) $n(91) 50
	if {$verbose} { puts -nonewline "170..."; flush stdout }
	$ns duplex-link $n(88) $n(90) 10M 7ms DropTail
	$ns queue-limit $n(88) $n(90) 50
	$ns duplex-link $n(89) $n(90) 1.5M 119ms DropTail
	$ns queue-limit $n(89) $n(90) 50
	$ns duplex-link $n(89) $n(91) 1.5M 154ms DropTail
	$ns queue-limit $n(89) $n(91) 50
	$ns duplex-link $n(90) $n(91) 10M 196ms DropTail
	$ns queue-limit $n(90) $n(91) 50
	$ns duplex-link $n(92) $n(93) 1.5M 126ms DropTail
	$ns queue-limit $n(92) $n(93) 50
	$ns duplex-link $n(92) $n(99) 1.5M 119ms DropTail
	$ns queue-limit $n(92) $n(99) 50
	$ns duplex-link $n(93) $n(95) 10M 210ms DropTail
	$ns queue-limit $n(93) $n(95) 50
	$ns duplex-link $n(93) $n(98) 1.5M 217ms DropTail
	$ns queue-limit $n(93) $n(98) 50
	$ns duplex-link $n(93) $n(99) 10M 224ms DropTail
	$ns queue-limit $n(93) $n(99) 50
	$ns duplex-link $n(94) $n(95) 10M 49ms DropTail
	$ns queue-limit $n(94) $n(95) 50
	if {$verbose} { puts -nonewline "180..."; flush stdout }
	$ns duplex-link $n(94) $n(96) 10M 84ms DropTail
	$ns queue-limit $n(94) $n(96) 50
	$ns duplex-link $n(94) $n(97) 1.5M 357ms DropTail
	$ns queue-limit $n(94) $n(97) 50
	$ns duplex-link $n(94) $n(99) 1.5M 126ms DropTail
	$ns queue-limit $n(94) $n(99) 50
	$ns duplex-link $n(95) $n(97) 10M 385ms DropTail
	$ns queue-limit $n(95) $n(97) 50
	$ns duplex-link $n(95) $n(98) 1.5M 308ms DropTail
	$ns queue-limit $n(95) $n(98) 50
	$ns duplex-link $n(96) $n(97) 1.5M 385ms DropTail
	$ns queue-limit $n(96) $n(97) 50
	$ns duplex-link $n(98) $n(99) 1.5M 168ms DropTail
	$ns queue-limit $n(98) $n(99) 50
	$ns queue-limit $n(98) $n(99) 50
	if {$verbose} { 
		puts -nonewline "187..."
		flush stdout
		puts "starting"
	}
	return 100}

# the main procedure
proc run {ns_ n leaf } {
	upvar $n node_
	upvar $leaf nl
	global p_ cnt

	# configure the Gnutella system parameters
	set sys [new PeerSys 100 2 2]
	$sys init-class classinfo.txt

	# create simple simulated bootstrap server
	set bootserver [new SocketApp/SmpBootServer]

	puts "start config"
	set rng [new RNG]
	$rng seed 0
	for {set i 0} {$i < $cnt } {incr i} {
		set p_($i) ""

		# peers are only attached to leaf nodes
		set nodeid [$nl($i) node-addr] 

		if { $i%10!=0 } {
			continue
		}

		# create and set up a Gnutella servent (legacy peer)
		set ptype [$rng uniform 0 2]
		if {$ptype < 1 } {
			set p_($i) [new PeerApp/GnutellaApp $nodeid 0]
		} else {
			set p_($i) [new PeerApp/GnutellaApp $nodeid 0]
		}

		$p_($i) use-smpbootserver $bootserver
		
		# attach the servent to the p2p system 
		set pfreeloader [$rng uniform 0 100]
		if {$pfreeloader < 50 } { ; # 50% are freeloaders
			$p_($i) attach-peersys $sys 0
		} else {
			$p_($i) attach-peersys $sys 1
		}
	
		set stime [$rng uniform 0 1000]
		$ns_ at $stime "$p_($i) start"
		puts "peer $i nodeid $nodeid start at $stime"

	}	
	
	# print out a timestamp periodically
	for {set i 1} {$i<20 } {incr i} {
		set timestamp [expr $i*50]
		set msg "timestamp${timestamp}"
		$ns_ at $timestamp "puts $msg"
	}
	puts "end config"
        $ns_ run
}

proc finish {} {
	global p_ cnt	

	for {set i 0 } {$i<$cnt} {incr i} {
		if {$i%10==0} {
		$p_($i) stop
		}
	}	
	puts "finished, dumping statistics..."
	for {set i 0 } {$i<$cnt} {incr i} {
		if {$i%10==0} {
		$p_($i) statistics
		}
	}	
	exit 0
}

set ns [new Simulator]
set n "node"
set nl "leaf"
create-topology ns $n $nl 100
$ns at 1000 "finish"
run $ns $n $nl
