# Config parameters

# Number of peers to add to each leaf node
set MinPeers 10
set MaxPeers 20
set NumPeersDistr "uniform"

# A bit of preprocessing that sed does better
exec sed -f brite_preproc.sed < 5_top.tcl > 5_top.pre.tcl

set hFile [open 5_top.pre.tcl r]
set buf [read $hFile]
close $hFile

# Some useful patterns
set SpacePat_ "\[ \t]"
set LeafPat_ "set leaf.\[0-9]*.$SpacePat_*\[0-9]*"
set InsertionPointPat_ "# Insertion Point"
set SecondInsertionPointPat_ "# I2nsertion Point"

# TODO: AD - remove
set ns [new Simulator]

# Find out how many nodes there are
regexp "set num_node \[0-9]*" $buf num_node
regexp "\[0-9]*$" $num_node num_node

set next_node $num_node
set next_peer 0

while { [regexp "$LeafPat_" $buf var] == 1 } {

    # Got the info. Remove that line.
    regsub "$LeafPat_" $buf "" buf

    # Just keep the node number part.
    regexp "\[0-9]*$" $var leaf_node_number

    set rng [new RNG]
    set nodes_to_add [$rng $NumPeersDistr $MinPeers $MaxPeers]

    for {set ctr 0} {$ctr < $nodes_to_add} {incr ctr} {
        # TODO: AD - randomize the link parameters too...
        set NewConnPatt_ "\$ns duplex-link \$n($next_node) \$n($leaf_node_number) 10.0Mb 2.7581716954814186ms \$qtype"
        regsub "$InsertionPointPat_" $buf "$NewConnPatt_\n\t# Insertion Point" buf

        # Add to Peer array
        set NewPeerPatt_ "set peer($next_peer) $next_node"
        regsub "$SecondInsertionPointPat_" $buf "$NewPeerPatt_\n\t# I2nsertion Point" buf

        
        incr next_node
        incr next_peer
        incr num_node
    }
}

regsub "set num_node \[0-9]*" $buf "set num_node $num_node" buf
regsub "set num_peer xx" $buf "set num_peer $next_peer" buf

# Write out the file
set hFile [open 5_top.out.tcl w]
puts $hFile $buf
close $hFile


