//=============================================================================
// File: vivaldimanager.cc
// Author: Andre Dufour
//=============================================================================

#include "vivaldimanager.h"
#include "gnutcoord.h"
#include "gnut_util.h"
#include <cmath>
#include <iostream>

//=============================================================================
//const double VivaldiManager::CC = 0.25;
const double VivaldiManager::CC = 0.25;
// Recommended value in Vivaldi paper

// const double VivaldiManager::CE = 0.05;
const double VivaldiManager::CE = 1.0;
// No value specified in paper!!!

//=============================================================================
VivaldiManager::VivaldiManager(void)
: mError(IVivaldiManager::NEW_NODE_ERROR)
{ }
//=============================================================================
VivaldiManager::~VivaldiManager(void)
{ }
//=============================================================================
GnutCoord 
VivaldiManager::getCoordinates(void) const
{
    return mCoordinates;
}
//=============================================================================
void 
VivaldiManager::updateCoordinates(
    const GnutCoord& aRemoteCoord,
    double aRtt,
    double aRemoteError)
{
#if 0
std::cout << "My coordinates: " << mCoordinates << std::endl 
     << "Remote coord:   " << aRemoteCoord << std::endl
     << "Rtt:            " << aRtt << std::endl;
     fflush(NULL);
#endif 

    const GnutCoord coord_diff = mCoordinates - aRemoteCoord;

//    std::cout << "RTT = " << aRtt << std::endl;
//    std::cout << "DIF = " << coord_diff.funkyAbs() << std::endl;
//    std::cout << "mER = " << mError << std::endl;

    GNUT_ASSERT(finite(aRemoteError));
    GNUT_ASSERT(finite(aRtt));

    GNUT_ASSERT(aRtt > 0.0);
    GNUT_ASSERT(aRemoteError >= 0.0);

    const double w = mError / (mError + aRemoteError);
//    std::cout << "w = " << w << std::endl;

    //GnutUtil::gnutError("mError: %f\naRemoteError: %f\nstep%f\n",
    //                    mError, aRemoteError, step);
    GNUT_ASSERT(w >= 0.0);
    GNUT_ASSERT(w <= 1.0);



//    std::cout << "mCoordinates " << mCoordinates << std::endl;
//    std::cout << "aRemoteCoord " << aRemoteCoord << std::endl;
//    std::cout << "Coorddiff " << coord_diff << std::endl;

    const double es = fabs(coord_diff.funkyAbs() - aRtt) / aRtt;
//    std::cout << "es = " << es << std::endl;

    mError = es * CE * w
             + mError  * (1.0 - CE * w);
//    std::cout << "ei = " << mError << std::endl;

    GNUT_ASSERT(mError >= 0.0);

    if (!finite(mError) || mError > IVivaldiManager::NEW_NODE_ERROR)
    {
        mError = IVivaldiManager::NEW_NODE_ERROR;
    }

    const double delta = CC * w;
//    std::cout << "delta = " << delta << std::endl;

//    const GnutCoord new_direction =  mCoordinates.awayFrom(aRemoteCoord);

    GnutCoord new_direction = coord_diff;

//    std::cout << "New direction " << new_direction << std::endl;


    if (aRtt > coord_diff.funkyAbs())
    {
//        std::cout << "Nodes too close" << std::endl;
//        std::cout << "Error magnitude: " << aRtt - coord_diff.funkyAbs() 
//                  << std::endl;
    }
    else
    {
//        std::cout << "Nodes too far" << std::endl;
//        std::cout << "Error magnitude: " << coord_diff.funkyAbs() - aRtt
//                  << std::endl;
    }

    mCoordinates = mCoordinates + delta * (aRtt - coord_diff.funkyAbs()) * 
                   GnutCoord(1, new_direction); 
//    std::cout << "actual amount moved = " << delta * 
//        (aRtt - coord_diff.funkyAbs()) * GnutCoord(1, new_direction)
//        << std::endl;
//    std::cout << "xi (after update) = " << mCoordinates << std::endl;

//    if (mCoordinates.mHeight < 1.0)
//        mCoordinates.mHeight = 1.0;

//    GNUT_ASSERT(mCoordinates.mHeight >= 0.0);
}
//=============================================================================
void 
VivaldiManager::resetCoordinates(void)
{ 
    mCoordinates = GnutCoord();
    mError = IVivaldiManager::NEW_NODE_ERROR;
}
//=============================================================================
double 
VivaldiManager::getLocalError(void) const
{
    return mError;
}
//=============================================================================
double 
VivaldiManager::estimateRtt(const GnutCoord& aRemoteCoord) const
{
    return (mCoordinates - aRemoteCoord).funkyAbs();
}
//=============================================================================

