//=============================================================================
// File: vivaldimanager.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: GnutellaSim implementation for the Vivaldi cooridnate system.
//=============================================================================

#ifndef __VIVALDIMANAGER_H__
#define __VIVALDIMANAGER_H__

#include "vivaldimanagerbc.h"
#include "gnutcoord.h"

class VivaldiManager : public VivaldiManagerBC
{
    // = FOUNDATION
public:
    VivaldiManager(void);
    virtual ~VivaldiManager(void);


    // = IVivaldiManager

    virtual GnutCoord getCoordinates(void) const;

    virtual void updateCoordinates(
            const GnutCoord& aRemoteCoord,
            double aRtt,
            double aRemoteError);
    
    virtual void resetCoordinates(void);

    virtual double getLocalError(void) const;

    virtual double estimateRtt(const GnutCoord& aRemoteCoord) const;

private:
    // = DATA

    GnutCoord mCoordinates;
    double    mError;

    // = CONSTANTS

    static const double CC;
    // Scaling factor for timestep

    static const double CE;
    // Tuning parameter for calculation of the error's moving average

    // = FOUNDATION

    // Disable copy constructor and assignment operator
    VivaldiManager(const VivaldiManager&);
    VivaldiManager& operator=(const VivaldiManager&);

};
//=============================================================================
#endif /* __VIVALDIMANAGER_H__ */

