% T3Rsameside (Modified Nodal Equations) using Homotopy

clear all
clc

global a

% Initial Guess

a = [1.4; 1.17 ; 0.673];

% Determine a root of the homotopy function when lambda = 0

X0 = fsolve('T3Rsamesideinit',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('T3RsamesideJac',X0,2500);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for T3Rsameside (Modified Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages and Currents')
leg = legend('v(1)','v(2)','v(3)');
set(leg,'Location','NorthWest')
axis([-1 1.2 -80 60])
grid 

% Display the final solutions of the nonlinear system of equations

%clc
disp('The final solutions for T3Rsameside (Modified Nodal Equations) are')
disp('     Sol1      ')
disp(vs)