function DH = T3RsamesideJac(lambda,X)

% Calculates jacobian function 
%             (Modified Nodal Equations)

global a

% Leakage Vector
Gleak = 1e-3;

% Homotopy Function Used
% H = (1-lambda)*Gleak*(X-a) + lambda*equation(X);

dHdX = (1-lambda)*Gleak*eye(3) + lambda*jacobian(X);
dHdlambda = -Gleak*(X-a) + equation(X);

DH = [dHdlambda dHdX];

end