function [JAC] = jacobian(X)

% JACOBIAN Calculates the value of the Jacobian for given values of lambda
%          and X for Schmitt Trigger Circuit 1 (Modified Nodal Equations)

% Circuit Parameters

r1 = 100;
r2 = 50000;
r3 = 50000;

% BJT Parameters

q1IS = 1e-14;
q1BF = 200;
q1BR = 3;
q1N = 38.78;
q2IS = 1e-14;
q2BF = 250;
q2BR = 3;
q2N = 38.78;

% Ebers-Moll Transistor Model

% fe1 = -Is/af*(exp(-n*(X(2)-X(5)))-1);
% fc1 = -Is/ar*(exp(-n*(X(1)-X(5)))-1);
% fe2 = -Is/af*(exp(-n*(X(2)-X(4)))-1);
% fc2 = -Is/ar*(exp(-n*(X(3)-X(4)))-1);

% Ie1 = fe1 - ar*fc1;
% Ic1 = fc1 - af*fe1;
% Ie2 = fe2 - ar*fc2;
% Ic2 = fc2 - af*fe2;

JAC(1, 2) =  (q1IS * q1N / q1BR)*(1 + q1BR)*(exp( - q1N*(X(2) - X(3)))) + ( - q2IS * q2N)*(exp(q2N*(X(1) - X(2)))) + (q2IS * q2N / q2BR )*(1 + q2BR )*(exp(q2N*(X(3)-X(2)))) + (q2IS * q2N / q2BF )*(1 + q2BF )*(exp(q2N*(X(1) - X(2)))) - (q2IS * q2N)*(exp(q2N*(X(3) - X(2)))) + 1/r1 + 1/r2 + 1/r3 ;

JAC(1, 3) =  (q1IS * q1N)*(exp( - q1N*( - X(3))))  - (q1IS * q1N / q1BR)*(1 + q1BR)*(exp( - q1N*(X(2)-X(3)))) + ( - q2IS * q2N / q2BR)*(1 + q2BR)*(exp(q2N*(X(3) - X(2)))) + (q2IS * q2N)*(exp(q2N*(X(3) - X(2)))) + 0 + 0 + (-1/r3) ;

JAC(1, 1) =  0 + (q2IS * q2N)*(exp(q2N*(X(1) - X(2)))) - (q2IS * q2N / q2BF)*(1 + q2BF)*(exp(q2N*(X(1) - X(2)))) + (-1/r1) + 0 + 0 ;

JAC(2, 2) =  ( - q1IS * q1N / q1BR)*(1 + q1BR)*(exp(-q1N*(X(2) - X(3)))) + (q1IS * q1N)*(exp(-q1N*(X(2) - X(3)))) + (q2IS * q2N)*(exp( q2N*(X(1) - X(2))))  - (q2IS * q2N / q2BR)*(1 + q2BR)*(exp( q2N*(X(3)-X(2)))) + (-1/r3) ;

JAC(2, 3) =  ( - q1IS * q1N)*(exp(-q1N*( - X(3)))) + (q1IS * q1N / q1BR )*(1 + q1BR )*(exp(-q1N*(X(2)-X(3)))) + (q1IS * q1N / q1BF )*(1 + q1BF )*(exp(-q1N*( - X(3)))) - (q1IS * q1N)*(exp(-q1N*(X(2) - X(3)))) + (q2IS * q2N / q2BR)*(1 + q2BR)*(exp( q2N*(X(3) - X(2)))) + 1/r3 ;

JAC(2, 1) =  0 + ( - q2IS * q2N)*(exp( q2N*(X(1) - X(2)))) + 0 ;

JAC(3, 2) =  ( - q2IS * q2N / q2BF)*(1 + q2BF)*(exp(q2N*(X(1)-X(2)))) + (q2IS * q2N)*(exp(q2N*(X(3) - X(2)))) + 0 + (-1/r1) ;

JAC(3, 3) =  ( -  q2IS * q2N)*(exp(q2N*(X(3) - X(2)))) + 0 + 0 ;

JAC(3, 1) =  (q2IS * q2N / q2BF)*(1 + q2BF)*(exp(q2N*(X(1) - X(2)))) + 0 + 1/r1 ;


% F = F';

end