% chua circuit (Modified Nodal Equations) using Homotopy

clear all
clc

global a
global Gleak
% Initial Guess
Gleak = 1e-3;
a = [0.0759-(10/Gleak); 0.0540; 0.5308; 0.7792; 0.9340; 0.1299; 0.5688; 0.4694; 0.0119; 0.3371; 0.1622-(2/Gleak); 0.7943; 0.3112-(12/Gleak); 0.5285-(12/Gleak); 0.1656; 0.6020; 0.2630; 0.6541];

% Determine a root of the homotopy function when lambda = 0

X0 = fsolve('chuainit',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('chuaJac',X0,2500);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for Chua Circuit (Modified Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages and Currents')
leg = legend('v(1)','v(2)','v(3)','v(4)','v(5)','v(6)','v(7)','v(8)','v(9)','v(10)','v(11)','v(12)','v(13)','v(14)','i(vcc1)','i(vcc2)','i(v1)','i(v2)');
set(leg,'Location','NorthEastOutside')
axis([0 1.2 -24 24])
grid 

% Display the final solutions of the nonlinear system of equations

clc
disp('The final solutions for Chua Circuit (Modified Nodal Equations) are')
disp('     Sol1      Sol2      Sol3      Sol4      Sol5      Sol6      Sol7      Sol8      Sol9')
disp(vs)