% T3Rsameside (Modified Nodal Equations) using Homotopy

clear all
clc

global a
global Gleak
% Initial Guess
Gleak = 0.0056;
a = [1.369; 1.17 ; 0.673-(0.0020/Gleak)];

% Determine a root of the homotopy function when lambda = 0

X0 = fsolve('T3Rsamesideinit',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('T3RsamesideJac',X0,2500);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for T3Rsameside (Modified Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages and Currents')
leg = legend('v(1)','v(2)','v(3)','v(4)','v(5)','v(6)','i(vcc)','i(vin)');
set(leg,'Location','NorthWest')
axis([0 1.2 -1 12])
grid 

% Display the final solutions of the nonlinear system of equations

%clc
disp('The final solutions for T3Rsameside (Modified Nodal Equations) are')
disp('     Sol1      ')
disp(vs)