function c = hermite(a,b,fa,fb,fpa,fpb)

% HERMITE Calculates coefficients for Hermite polynomial

fab = (fb - fa)/(b - a);
faab = (fab - fpa)/(b - a);
faabb = (fpb - 2*fab + fpa)/(b - a)^2;
c = [zeros(1,3) fa] + [zeros(1,2) fpa*[1 -a]] + [0 faab*conv([1 -a],[1 -a])] + faabb*conv(conv([1 -a],[1 -a]),[1 -b]);

end