% Schmitt Trigger Circuit 1 (Nodal Equations) using Homotopy

clear all
clc

global a

% Initial Guess

a = [0.5000; 0.4799; 0.9047; 0.6099; 0.6177; 0.8594];

% Determine a root of the homotopy function when lambda = 0

x0 = fsolve('Schmitt1init',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('Schmitt1Jac',x0,2500);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for Schmitt Trigger Circuit 1 (Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages')
leg = legend('v(1)','v(2)','v(3)','v(4)','v(5)','v(6)');
set(leg,'Location','NorthWest')
axis([0 1.2 -1 12])
grid 

% Display the final solutions of the nonlinear system of equations

clc
disp('The final solutions for Schmitt Trigger Circuit 1 (Nodal Equations) are')
disp('     Sol1      Sol2      Sol3')
disp(vs)