function DH = Schmitt1Jac(lambda,x)

% SCHMITT1JAC Calculates jacobian function for Schmitt Trigger Circuit 1
%             (Nodal Equations)

global a

% Leakage Vector
Gleak = 1e-3;

% Homotopy Function Used
% H = (1-lambda)*Gleak*(x-a) + lambda*equation(x);

dHdx = (1-lambda)*Gleak*eye(6) + lambda*jacobian(x);
dHdlambda = -Gleak*(x-a) + equation(x);

DH = [dHdlambda dHdx];

end