% Schmitt Trigger Circuit 2 (Modified Nodal Equations) using Homotopy

clear all
clc

global a

% Initial Guess

a = [0.5828; 0.5862; 0.9258; 0.5751; 0.0100; 0.8094; 0.6088];

% Determine a root of the homotopy function when lambda = 0
x0 = fsolve('Schmitt2init',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('Schmitt2Jac',x0,250);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for Schmitt Trigger Circuit 2 (Modified Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages and Currents')
leg = legend('v(1)','v(2)','v(3)','v(4)','v(5)','v(6)','i(vcc)');
set(leg,'Location','NorthWest')
axis([0 1.2 -1 12])
grid 

% Display the final solutions of the nonlinear system of equations

clc
disp('The final solutions for Schmitt Trigger Circuit 2 (Modified Nodal Equations) are')
disp('     Sol1      Sol2      Sol3')
disp(vs)