function [JAC] = jacobian(X)

% JACOBIAN Calculates the value of the Jacobian for given values of lambda
%          and x for Chua Circuit (Modified Nodal Equations)

% Circuit Parameters

R1 = 10000;
R2 = 4000;
R3 = 4000;
R4 = 5000;
R5 = 30000;
R6 = 500;
R7 = 500;
R8 = 30000;
R9 = 10100;
R10 = 10100;
R11 = 4000;
R12 = 4000;
R13 = 30000;
R14 = 30000;

% Voltage Sources

% VCC1 = 12;
% VCC2 = 12;
% V1 = 10;
% V2 = 2;

% BJT Parameters

Q1IS = 1e-9;
Q1BF = 100;
Q1BR = 1;
Q1N = 38.7766;
Q2IS = 1e-9;
Q2BF = 100;
Q2BR = 1;
Q2N = 38.7766;
Q3IS = 1e-9;
Q3BF = 100;
Q3BR = 1;
Q3N = 38.7766;
Q4IS = 1e-9;
Q4BF = 100;
Q4BR = 1;
Q4N = 38.7766;

% Ebers-Moll Transistor Model

% Ic1 = Q1IS*(exp(-Q1N*(X(8)-X(1)))-1) - Q1IS/Q1BR*(1+Q1BR)*(exp(-Q1N*(X(4)-X(1)))-1);
% Ic2 = Q2IS*(exp(-Q2N*(X(8)-X(6)))-1) - Q2IS/Q2BR*(1+Q2BR)*(exp(-Q2N*(X(10)-X(6)))-1);
% Ic3 = Q3IS*(exp(-Q3N*(X(9)-X(1)))-1) - Q3IS/Q3BR*(1+Q3BR)*(exp(-Q3N*(X(5)-X(1)))-1);
% Ic4 = Q4IS*(exp(-Q4N*(X(9)-X(7)))-1) - Q4IS/Q4BR*(1+Q4BR)*(exp(-Q4N*(X(12)-X(7)))-1);

% Ie1 = - Q1IS/Q1BF*(1+Q1BF)*(exp(-Q1N*(X(8)-X(1)))-1) + Q1IS*(exp(-Q1N*(X(4)-X(1)))-1);
% Ie2 = - Q2IS/Q2BF*(1+Q2BF)*(exp(-Q2N*(X(8)-X(6)))-1) + Q2IS*(exp(-Q2N*(X(10)-X(6)))-1);
% Ie3 = - Q3IS/Q3BF*(1+Q3BF)*(exp(-Q3N*(X(9)-X(1)))-1) + Q3IS*(exp(-Q3N*(X(5)-X(1)))-1);
% Ie4 = - Q4IS/Q4BF*(1+Q4BF)*(exp(-Q4N*(X(9)-X(7)))-1) + Q4IS*(exp(-Q4N*(X(12)-X(7)))-1);

% F(1) = (X(1)-X(2)) - V1;

JAC(1,1) = 1 + 0;
JAC(1,2) = - 1 + 0;
JAC(1,3) = 0 + 0;
JAC(1,4) = 0 + 0;
JAC(1,5) = 0 + 0;
JAC(1,6) = 0 + 0;
JAC(1,7) = 0 + 0;
JAC(1,8) = 0 + 0;
JAC(1,9) = 0 + 0;
JAC(1,10) = 0 + 0;
JAC(1,11) = 0 + 0;
JAC(1,12) = 0 + 0;
JAC(1,13) = 0 + 0;
JAC(1,14) = 0 + 0;
JAC(1,15) = 0 + 0;
JAC(1,16) = 0 + 0;
JAC(1,17) = 0 + 0;
JAC(1,18) = 0 + 0;

% F(2) = (X(2)-X(3))/R1 - X(17);

JAC(2,1) = 0 + 0;
JAC(2,2) = 1/R1 + 0;
JAC(2,3) = - 1/R1 + 0;
JAC(2,4) = 0 + 0;
JAC(2,5) = 0 + 0;
JAC(2,6) = 0 + 0;
JAC(2,7) = 0 + 0;
JAC(2,8) = 0 + 0;
JAC(2,9) = 0 + 0;
JAC(2,10) = 0 + 0;
JAC(2,11) = 0 + 0;
JAC(2,12) = 0 + 0;
JAC(2,13) = 0 + 0;
JAC(2,14) = 0 + 0;
JAC(2,15) = 0 + 0;
JAC(2,16) = 0 + 0;
JAC(2,17) = 0 - 1;
JAC(2,18) = 0 + 0;

% F(3) = (X(3)-X(2))/R1 + (X(3)-X(10))/R13 - X(18);

JAC(3,1) = 0 + 0 + 0;
JAC(3,2) = - 1/R1 + 0 + 0;
JAC(3,3) = 1/R1 + 1/R13 + 0;
JAC(3,4) = 0 + 0 + 0;
JAC(3,5) = 0 + 0 + 0;
JAC(3,6) = 0 + 0 + 0;
JAC(3,7) = 0 + 0 + 0;
JAC(3,8) = 0 + 0 + 0;
JAC(3,9) = 0 + 0 + 0;
JAC(3,10) = 0 - 1/R13 + 0;
JAC(3,11) = 0 + 0 + 0;
JAC(3,12) = 0 + 0 + 0;
JAC(3,13) = 0 + 0 + 0;
JAC(3,14) = 0 + 0 + 0;
JAC(3,15) = 0 + 0 + 0;
JAC(3,16) = 0 + 0 + 0;
JAC(3,17) = 0 + 0 + 0;
JAC(3,18) = 0 + 0 - 1;

% F(4) = (X(4)-X(13))/R2 + (X(4)-X(6))/R5 + Ic1;

JAC(4,1) =  0 + 0 + Q1IS*Q1N*(exp(-Q1N*(X(8)-X(1)))) - Q1IS*Q1N/Q1BR*(1+Q1BR)*(exp(-Q1N*(X(4)-X(1))));
JAC(4,2) = 0 + 0 + 0;
JAC(4,3) = 0 + 0 + 0;
JAC(4,4) =  1/R2 + 1/R5 + Q1IS*Q1N/Q1BR*(1+Q1BR)*(exp(-Q1N*(X(4)-X(1))));
JAC(4,5) = 0 + 0 + 0;
JAC(4,6) = 0 - 1/R5 + 0;
JAC(4,7) = 0 + 0 + 0;
JAC(4,8) =  0 + 0 - Q1IS*Q1N*(exp(-Q1N*(X(8)-X(1))));
JAC(4,9) = 0 + 0 + 0;
JAC(4,10) = 0 + 0 + 0;
JAC(4,11) = 0 + 0 + 0;
JAC(4,12) = 0 + 0 + 0;
JAC(4,13) = - 1/R2 + 0 + 0 ;
JAC(4,14) = 0 + 0 + 0;
JAC(4,15) = 0 + 0 + 0; 
JAC(4,16) = 0 + 0 + 0;
JAC(4,17) = 0 + 0 + 0;
JAC(4,18) = 0 + 0 + 0;
JAC(4, 14) =  0 + 0 + 0 ;

% F(5) = (X(5)-X(14))/R3 + (X(5)-X(7))/R8 + Ic3;

JAC(5,1) = 0 + 0 + Q3IS*Q3N*(exp(-Q3N*(X(9)-X(1)))) - Q3IS*Q3N/Q3BR*(1+Q3BR)*(exp(-Q3N*(X(5)-X(1))));
JAC(5,2) = 0 + 0 + 0;
JAC(5,3) = 0 + 0 + 0;
JAC(5,4) = 0 + 0 + 0;
JAC(5,5) = 1/R3 + 1/R8 + Q3IS*Q3N/Q3BR*(1+Q3BR)*(exp(-Q3N*(X(5)-X(1))));
JAC(5,6) = 0 + 0 + 0;
JAC(5,7) = 0 - 1/R8 + 0;
JAC(5,8) = 0 + 0 + 0;
JAC(5,9) = 0 + 0 - Q3IS*Q3N*(exp(-Q3N*(X(9)-X(1))));
JAC(5,10) = 0 + 0 + 0;
JAC(5,11) = 0 + 0 + 0;
JAC(5,12) = 0 + 0 + 0;
JAC(5,13) = 0 + 0 + 0;
JAC(5,14) = - 1/R3 + 0 + 0;
JAC(5,15) = 0 + 0 + 0; 
JAC(5,16) = 0 + 0 + 0; 
JAC(5,17) = 0 + 0 + 0; 
JAC(5,18) = 0 + 0 + 0; 

% F(6) = (X(6)-X(4))/R5 + X(6)/R9 - Ic2 - Ie2;   

JAC(6,1) = 0 + 0 + 0 + 0;
JAC(6,2) = 0 + 0 + 0 + 0;
JAC(6,3) = 0 + 0 + 0 + 0;
JAC(6,4) = - 1/R5 + 0 + 0;
JAC(6,5) = 0 + 0 + 0 + 0;
JAC(6,6) = 1/R5 + 1/R9 - Q2IS*Q2N*(exp(-Q2N*(X(8)-X(6)))) + Q2IS*Q2N/Q2BR*(1+Q2BR)*(exp(-Q2N*(X(10)-X(6)))) + Q2IS*Q2N/Q2BF*(1+Q2BF)*(exp(-Q2N*(X(8)-X(6)))) - Q2IS*Q2N*(exp(-Q2N*(X(10)-X(6))));
JAC(6,7) = 0 + 0 + 0 + 0;
JAC(6,8) = 0 + 0 + Q2IS*Q2N*(exp(-Q2N*(X(8)-X(6)))) - Q2IS*Q2N/Q2BF*(1+Q2BF)*(exp(-Q2N*(X(8)-X(6))));
JAC(6,9) = 0 + 0 + 0 + 0;
JAC(6,10) = 0 + 0 - Q2IS*Q2N/Q2BR*(1+Q2BR)*(exp(-Q2N*(X(10)-X(6)))) + Q2IS*Q2N*(exp(-Q2N*(X(10)-X(6))));
JAC(6,11) = 0 + 0 + 0 + 0;
JAC(6,12) = 0 + 0 + 0 + 0;
JAC(6,13) = 0 + 0 + 0 + 0;
JAC(6,14) = 0 + 0 + 0 + 0;
JAC(6,15) = 0 + 0 + 0 + 0; 
JAC(6,16) = 0 + 0 + 0 + 0;
JAC(6,17) = 0 + 0 + 0 + 0;
JAC(6,18) = 0 + 0 + 0 + 0;

% F(7) = (X(7)-X(5))/R8 + X(7)/R10 - Ic4 - Ie4;  

JAC(7,1) = 0 + 0 + 0 + 0;
JAC(7,2) = 0 + 0 + 0 + 0;
JAC(7,3) = 0 + 0 + 0 + 0;
JAC(7,4) = 0 + 0 + 0 + 0;
JAC(7,5) = - 1/R8 + 0 + 0 + 0;
JAC(7,6) = 0 + 0 + 0 + 0;
JAC(7,7) = 1/R8 + 1/R10 - Q4IS*Q4N*(exp(-Q4N*(X(9)-X(7)))) + Q4IS*Q4N/Q4BR*(1+Q4BR)*(exp(-Q4N*(X(12)-X(7)))) + Q4IS*Q4N/Q4BF*(1+Q4BF)*(exp(-Q4N*(X(9)-X(7)))) - Q4IS*Q4N*(exp(-Q4N*(X(12)-X(7))));
JAC(7,8) = 0 + 0 + 0 + 0;
JAC(7,9) = 0 + 0 + Q4IS*Q4N*(exp(-Q4N*(X(9)-X(7)))) - Q4IS*Q4N/Q4BF*(1+Q4BF)*(exp(-Q4N*(X(9)-X(7))));
JAC(7,10) = 0 + 0 + 0 + 0;
JAC(7,11) = 0 + 0 + 0 + 0;
JAC(7,12) = 0 + 0 - Q4IS*Q4N/Q4BR*(1+Q4BR)*(exp(-Q4N*(X(12)-X(7)))) + Q4IS*Q4N*(exp(-Q4N*(X(12)-X(7))));
JAC(7,13) = 0 + 0 + 0 + 0;
JAC(7,14) = 0 + 0 + 0 + 0;
JAC(7,15) = 0 + 0 + 0 + 0;
JAC(7,16) = 0 + 0 + 0 + 0;
JAC(7,17) = 0 + 0 + 0 + 0;
JAC(7,18) = 0 + 0 + 0 + 0;

% F(8) = X(8)/R6 + Ie1 + Ie2;  

JAC(8,1) = 0 - Q1IS*Q1N/Q1BF*(1+Q1BF)*(exp(-Q1N*(X(8)-X(1)))) + Q1IS*Q1N*(exp(-Q1N*(X(4)-X(1)))) + 0;
JAC(8,2) = 0 + 0 + 0;
JAC(8,3) = 0 + 0 + 0;
JAC(8,4) = 0 - Q1IS*Q1N*(exp(-Q1N*(X(4)-X(1)))) + 0 ;
JAC(8,5) = 0 + 0 + 0;
JAC(8,6) = 0 + 0 - Q2IS*Q2N/Q2BF*(1+Q2BF)*(exp(-Q2N*(X(8)-X(6)))) + Q2IS*Q2N*(exp(-Q2N*(X(10)-X(6))));
JAC(8,7) = 0 + 0 + 0;
JAC(8,8) = 1/R6 + Q1IS*Q1N/Q1BF*(1+Q1BF)*(exp(-Q1N*(X(8)-X(1)))) + Q2IS*Q2N/Q2BF*(1+Q2BF)*(exp(-Q2N*(X(8)-X(6))));
JAC(8,9) = 0 + 0 + 0;
JAC(8,10) = 0 + 0 - Q2IS*Q2N*(exp(-Q2N*(X(10)-X(6))));
JAC(8,11) = 0 + 0 + 0;
JAC(8,12) = 0 + 0 + 0;
JAC(8,13) = 0 + 0 + 0;
JAC(8,14) = 0 + 0 + 0; 
JAC(8,15) = 0 + 0 + 0;
JAC(8,16) = 0 + 0 + 0; 
JAC(8,17) = 0 + 0 + 0; 
JAC(8,18) = 0 + 0 + 0; 

% F(9) = X(9)/R7 + Ie3 + Ie4;  

JAC(9,1) = 0 - Q3IS*Q3N/Q3BF*(1+Q3BF)*(exp(-Q3N*(X(9)-X(1)))) + Q3IS*Q3N*(exp(-Q3N*(X(5)-X(1)))) + 0;
JAC(9,2) = 0 + 0 + 0;
JAC(9,3) = 0 + 0 + 0;
JAC(9,4) = 0 + 0 + 0;
JAC(9,5) = 0 - Q3IS*Q3N*(exp(-Q3N*(X(5)-X(1)))) + 0;
JAC(9,6) = 0 + 0 + 0;
JAC(9,7) = 0 + 0 + 0 - Q4IS*Q4N/Q4BF*(1+Q4BF)*(exp(-Q4N*(X(9)-X(7)))) + Q4IS*Q4N*(exp(-Q4N*(X(12)-X(7))));
JAC(9,8) = 0 + 0 + 0;
JAC(9,9) = 1/R7 + Q3IS*Q3N/Q3BF*(1+Q3BF)*(exp(-Q3N*(X(9)-X(1)))) + Q4IS*Q4N/Q4BF*(1+Q4BF)*(exp(-Q4N*(X(9)-X(7))));
JAC(9,10) = 0 + 0 + 0;
JAC(9,11) = 0 + 0 + 0;
JAC(9,12) = 0 + 0 + 0 - Q4IS*Q4N*(exp(-Q4N*(X(12)-X(7))));
JAC(9,13) = 0 + 0 + 0;
JAC(9,15) = 0 + 0 + 0;
JAC(9,14) = 0 + 0 + 0;
JAC(9,16) = 0 + 0 + 0;
JAC(9,17) = 0 + 0 + 0;
JAC(9,18) = 0 + 0 + 0;

% F(10) = (X(10)-X(13))/R11 + (X(10)-X(3))/R13 + Ic2;  

JAC(10,1) = 0 + 0 + 0;
JAC(10,2) = 0 + 0 + 0;
JAC(10,3) = 0 - 1/R13 + 0;
JAC(10,4) = 0 + 0 + 0;
JAC(10,5) = 0 + 0 + 0;
JAC(10,6) = 0 + 0 + Q2IS*Q2N*(exp(-Q2N*(X(8)-X(6)))) - Q2IS*Q2N/Q2BR*(1+Q2BR)*(exp(-Q2N*(X(10)-X(6))));
JAC(10,7) = 0 + 0 + 0;
JAC(10,8) = 0 + 0 - Q2IS*Q2N*(exp(-Q2N*(X(8)-X(6))));
JAC(10,9) = 0 + 0 + 0;
JAC(10,10) = 1/R11 + 1/R13 + Q2IS*Q2N/Q2BR*(1+Q2BR)*(exp(-Q2N*(X(10)-X(6))));
JAC(10,11) = 0 + 0 + 0;
JAC(10,12) = 0 + 0 + 0;
JAC(10,13) = - 1/R11 + 0 + 0;
JAC(10,14) = 0 + 0 + 0;
JAC(10,15) = 0 + 0 + 0;
JAC(10,16) = 0 + 0 + 0;
JAC(10,17) = 0 + 0 + 0;
JAC(10,18) = 0 + 0 + 0;

% F(11) = (X(11)-X(3)) - V2;

JAC(11,1) = 0 + 0;
JAC(11,2) = 0 + 0;
JAC(11,3) = - 1 + 0;
JAC(11,4) = 0 + 0;
JAC(11,5) = 0 + 0;
JAC(11,6) = 0 + 0;
JAC(11,7) = 0 + 0;
JAC(11,8) = 0 + 0;
JAC(11,9) = 0 + 0;
JAC(11,10) = 0 + 0;
JAC(11,11) = 1 + 0;
JAC(11,12) = 0 + 0;
JAC(11,13) = 0 + 0;
JAC(11,14) = 0 + 0;
JAC(11,15) = 0 + 0;
JAC(11,16) = 0 + 0;
JAC(11,17) = 0 + 0;
JAC(11,18) = 0 + 0;

% F(12) = (X(12)-X(14))/R12 + (X(12)-X(11))/R14 + Ic4;  

JAC(12,1) = 0 + 0 + 0;
JAC(12,2) = 0 + 0 + 0;
JAC(12,3) = 0 + 0 + 0;
JAC(12,4) = 0 + 0 + 0;
JAC(12,5) = 0 + 0 + 0;
JAC(12,6) = 0 + 0 + 0;
JAC(12,7) = 0 + 0 + Q4IS*Q4N*(exp(-Q4N*(X(9)-X(7)))) - Q4IS*Q4N/Q4BR*(1+Q4BR)*(exp(-Q4N*(X(12)-X(7))));
JAC(12,8) = 0 + 0 + 0;
JAC(12,9) = 0 + 0 - Q4IS*Q4N*(exp(-Q4N*(X(9)-X(7))));
JAC(12,10) = 0 + 0 + 0;
JAC(12,11) = 0 - 1/R14 + 0;
JAC(12,12) = 1/R12 + 1/R14 + Q4IS*Q4N/Q4BR*(1+Q4BR)*(exp(-Q4N*(X(12)-X(7))));
JAC(12,13) = 0 + 0 + 0;
JAC(12,14) = - 1/R12 + 0 + 0;
JAC(12,15) = 0 + 0 + 0;
JAC(12,16) = 0 + 0 + 0;
JAC(12,17) = 0 + 0 + 0;
JAC(12,18) = 0 + 0 + 0;

% F(13) = X(13) - VCC1;

JAC(13,1) = 0 + 0;
JAC(13,2) = 0 + 0;
JAC(13,3) = 0 + 0;
JAC(13,4) = 0 + 0;
JAC(13,5) = 0 + 0;
JAC(13,6) = 0 + 0;
JAC(13,7) = 0 + 0;
JAC(13,8) = 0 + 0;
JAC(13,9) = 0 + 0;
JAC(13,10) = 0 + 0;
JAC(13,11) = 0 + 0;
JAC(13,12) = 0 + 0;
JAC(13,13) = 1 + 0;
JAC(13,14) = 0 + 0;
JAC(13,15) = 0 + 0;
JAC(13,16) = 0 + 0;
JAC(13,17) = 0 + 0;
JAC(13,18) = 0 + 0;

% F(14) = X(14) - VCC2;

JAC(14,1) = 0 + 0;
JAC(14,2) = 0 + 0;
JAC(14,3) = 0 + 0;
JAC(14,4) = 0 + 0;
JAC(14,5) = 0 + 0;
JAC(14,6) = 0 + 0;
JAC(14,7) = 0 + 0;
JAC(14,8) = 0 + 0;
JAC(14,9) = 0 + 0;
JAC(14,10) = 0 + 0;
JAC(14,11) = 0 + 0;
JAC(14,12) = 0 + 0;
JAC(14,13) = 0 + 0;
JAC(14,14) = 1 + 0;
JAC(14,15) = 0 + 0;
JAC(14,16) = 0 + 0;
JAC(14,17) = 0 + 0;
JAC(14,18) = 0 + 0;

% F(15) = (X(13)-X(4))/R2 + (X(13)-X(10))/R11 + X(15);

JAC(15,1) = 0 + 0 + 0;
JAC(15,2) = 0 + 0 + 0;
JAC(15,3) = 0 + 0 + 0;
JAC(15,4) = 0 - 1/R2 + 0;
JAC(15,5) = 0 + 0 + 0;
JAC(15,6) = 0 + 0 + 0;
JAC(15,7) = 0 + 0 + 0;
JAC(15,8) = 0 + 0 + 0;
JAC(15,9) = 0 + 0 + 0;
JAC(15,10) = 0 - 1/R11 + 0;
JAC(15,11) = 0 + 0 + 0;
JAC(15,12) = 0 + 0 + 0;
JAC(15,13) = 1/R2 + 1/R11 + 0;
JAC(15,14) = 0 + 0 + 0;
JAC(15,15) = 0 + 0 + 1;
JAC(15,16) = 0 + 0 + 0;
JAC(15,17) = 0 + 0 + 0;
JAC(15,18) = 0 + 0 + 0;

% F(16) = (X(14)-X(5))/R3 + (X(14)-X(12))/R12 + X(16);

JAC(16,1) = 0 + 0 + 0;
JAC(16,2) = 0 + 0 + 0;
JAC(16,3) = 0 + 0 + 0;
JAC(16,4) = 0 + 0 + 0;
JAC(16,5) = - 1/R3 + 0 + 0;
JAC(16,6) = 0 + 0 + 0;
JAC(16,7) = 0 + 0 + 0;
JAC(16,8) = 0 + 0 + 0;
JAC(16,9) = 0 + 0 + 0;
JAC(16,10) = 0 + 0 + 0;
JAC(16,11) = 0 + 0 + 0;
JAC(16,12) = 0 - 1/R12 + 0;
JAC(16,13) = 0 + 0 + 0;
JAC(16,14) = 1/R3 + 1/R12 + 0;
JAC(16,15) = 0 + 0 + 0;
JAC(16,16) = 0 + 0 + 1;
JAC(16,17) = 0 + 0 + 0;
JAC(16,18) = 0 + 0 + 0;

% F(17) = X(1)/R4 + X(17) - Ic1 - Ie1 - Ic3 - Ie3;

JAC(17,1) = 1/R4 + 0 - Q1IS*Q1N*(exp(-Q1N*(X(8)-X(1)))) + Q1IS*Q1N/Q1BR*(1+Q1BR)*(exp(-Q1N*(X(4)-X(1)))) + Q1IS*Q1N/Q1BF*(1+Q1BF)*(exp(-Q1N*(X(8)-X(1)))) - Q1IS*Q1N*(exp(-Q1N*(X(4)-X(1)))) - Q3IS*Q3N*(exp(-Q3N*(X(9)-X(1)))) + Q3IS*Q3N/Q3BR*(1+Q3BR)*(exp(-Q3N*(X(5)-X(1)))) + Q3IS*Q3N/Q3BF*(1+Q3BF)*(exp(-Q3N*(X(9)-X(1)))) - Q3IS*Q3N*(exp(-Q3N*(X(5)-X(1))));
JAC(17,2) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,3) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,4) = 0 + 0 - Q1IS*Q1N/Q1BR*(1+Q1BR)*(exp(-Q1N*(X(4)-X(1)))) + Q1IS*Q1N*(exp(-Q1N*(X(4)-X(1)))) + 0 + 0;
JAC(17,5) = 0 + 0 + 0 + 0 - Q3IS*Q3N/Q3BR*(1+Q3BR)*(exp(-Q3N*(X(5)-X(1)))) + Q3IS*Q3N*(exp(-Q3N*(X(5)-X(1))));
JAC(17,6) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,7) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,8) = 0 + 0 + Q1IS*Q1N*(exp(-Q1N*(X(8)-X(1)))) - Q1IS*Q1N/Q1BF*(1+Q1BF)*(exp(-Q1N*(X(8)-X(1)))) + 0 + 0;
JAC(17,9) = 0 + 0 + 0 + 0 + Q3IS*Q3N*(exp(-Q3N*(X(9)-X(1)))) - Q3IS*Q3N/Q3BF*(1+Q3BF)*(exp(-Q3N*(X(9)-X(1))));
JAC(17,10) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,11) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,12) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,13) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,14) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,15) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,16) = 0 + 0 + 0 + 0 + 0 + 0;
JAC(17,17) = 0 + 1 + 0 + 0 + 0 + 0;
JAC(17,18) = 0 + 0 + 0 + 0 + 0 + 0;

% F(18) = (X(11)-X(12))/R14 + X(18);

JAC(18,1) = 0 + 0;
JAC(18,2) = 0 + 0;
JAC(18,3) = 0 + 0;
JAC(18,4) = 0 + 0;
JAC(18,5) = 0 + 0;
JAC(18,6) = 0 + 0;
JAC(18,7) = 0 + 0;
JAC(18,8) = 0 + 0;
JAC(18,9) = 0 + 0;
JAC(18,10) = 0 + 0;
JAC(18,11) = 1/R14 + 0;
JAC(18,12) = - 1/R14 + 0;
JAC(18,13) = 0 + 0;
JAC(18,14) = 0 + 0;
JAC(18,15) = 0 + 0;
JAC(18,16) = 0 + 0;
JAC(18,17) = 0 + 0;
JAC(18,18) = 0 + 1;

% F = F';

end