/*
 * Decompiled with CFR 0.152.
 */
package phyloPMCMC;

import ev.ex.DataGenerator;
import ev.ex.PhyloSamplerMain;
import ev.ex.TreeGenerators;
import ev.poi.processors.TreeDistancesProcessor;
import ev.poi.processors.TreeTopologyProcessor;
import ev.to.NJ;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import ma.MSAParser;
import ma.MSAPoset;
import ma.SequenceType;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.Sampling;
import nuts.math.StatisticsMap;
import nuts.util.CollUtils;
import nuts.util.Counter;
import phyloPMCMC.InteractingParticleGibbs4K2P;
import phyloPMCMC.InteractingParticleGibbs4K2PBF;
import phyloPMCMC.MrBayes;
import phyloPMCMC.PGAS4K2PBF;
import phyloPMCMC.PGS4K2P;
import phyloPMCMC.PGS4K2PBF;
import phyloPMCMC.TreeProcessorBFState;
import pty.RandomRootedTrees;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.io.TreeEvaluator;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.smc.LazyParticleFilter;
import pty.smc.NCPriorPriorKernel;
import pty.smc.PG;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;
import smc.BackForwardKernel;
import smc.PartialCoalescentState4BackForwardKernel;

public class PGSExperiments
implements Runnable {
    @Option
    public boolean resampleRoot = false;
    @Option
    public InferenceMethod refMethod = InferenceMethod.SMC4GTRIGamma;
    @Option
    public double nThousandIters = 10.0;
    @Option
    public ArrayList<InferenceMethod> methods = CollUtils.list(Arrays.asList(InferenceMethod.SMC4K2P));
    @Option
    public ArrayList<Double> iterScalings = CollUtils.list(Arrays.asList(1.0));
    @Option
    public int refIterScaling = 100;
    @Option
    public int repPerDataPt = 1;
    @Option
    public double pmcmcSMCExpMix = 0.6666666666666666;
    @Option
    public double treeRatePrior = 10.0;
    public static DataGenerator.DataGeneratorMain generator = new DataGenerator.DataGeneratorMain();
    public static PhyloSamplerMain samplerMain = new PhyloSamplerMain();
    @Option
    public static Random mainRand = new Random(3L);
    @Option
    public boolean verbose = false;
    @Option
    public int nThreads = 1;
    @Option
    public int maxNUniqueParticles = Integer.MAX_VALUE;
    @Option
    public int finalMaxNUniqueParticles = Integer.MAX_VALUE;
    @Option
    public int nParticlesEachStep = 1000;
    @Option
    public double parameter_a = 1.2;
    @Option
    public double a_alpha = 1.5;
    @Option
    public double a_statFreqs = 100.0;
    @Option
    public double a_subsRates = 100.0;
    @Option
    public double a_pInv = 0.2;
    @Option
    public double pmmhPgsExpMix = 0.05;
    @Option
    public double burninPercent = 0.5;
    @Option
    public int sampleTreeEveryNIter = 1;
    @Option
    public String RcommandDir = "/Users/oudomame/phyloPMCMC/";
    @Option
    public boolean useDataGenerator = true;
    @Option
    public File dataFile = null;
    @Option
    public File refTree = null;
    @Option
    public String dataDirName = "output";
    @Option
    public SequenceType sequenceType = SequenceType.DNA;
    @Option
    public boolean isPMCMC4clock = true;
    @Option
    public boolean useNJinfo = false;
    @Option
    public boolean useTopologyProcessor = false;
    @Option
    public boolean saveTreesFromPMCMC = false;
    @Option
    public String nameOfAllTrees = "allTrees.trees";
    @Option
    public double csmc_trans2tranv = 2.0;
    @Option
    public double smcmcmcMix = 0.5;
    @Option
    public boolean betterStartVal = true;
    @Option
    public int nCSMC = 2;
    @Option
    public int nUCSMC = 2;
    @Option
    public boolean adaptiveTempDiff = false;
    @Option
    public double alphaSMCSampler = 0.95;
    @Option
    public double essRatioThreshold = 0.7;
    @Option
    public boolean sampleTrans2tranv = true;
    @Option
    public ParticleFilter.ResamplingStrategy resamplingStrategy = ParticleFilter.ResamplingStrategy.ESS;
    @Option
    public double mbRate = 1.0;
    @Option
    public boolean setToK2P = true;
    private double marginalLogLike = 0.0;
    private PrintWriter logZout = null;
    public File data = null;
    private File output = null;

    public static void main(String[] args) {
        IO.run((String[])args, (Object[])new Object[]{new PGSExperiments(), "pcs", PartialCoalescentState.class, "mb", MrBayes.instance, "gen", generator, "mcmc", samplerMain, "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "phylo", PhyloSampler._defaultPhyloSamplerOptions, "prior", PhyloSampler._defaultPriorOptions, "nj", NJ.class, "nc", NCPriorPriorKernel.class, "priorprior", PriorPriorKernel.class, "annealingKernel"});
    }

    protected void treeComparison() {
        this.logZout = IOUtils.openOutEasy((File)new File(Execution.getFile((String)"results"), "logZout.csv"));
        this.logZout.println(CSV.header((Object[])new Object[]{"treeName", "Method", "logZ"}));
        PrintWriter out = IOUtils.openOutEasy((File)new File(this.output, "results.csv"));
        out.println(CSV.header((Object[])new Object[]{"Method", "IterScale", "Repeat", "Metric", "Value", "TreeName", "Time"}));
        List files = null;
        files = this.useDataGenerator ? IO.ls((File)PGSExperiments.generator.output, (String)"msf") : IO.ls((File)new File(Execution.getFile((String)this.dataDirName)), (String)"msf");
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File f;
            this.data = f = (File)iterator.next();
            String treeName = f.getName();
            LogInfo.track((Object)("Current tree:" + treeName));
            UnrootedTree goldut = PGSExperiments.generator.useGutellData || !this.useDataGenerator ? (this.refTree == null ? null : UnrootedTree.fromRooted((RootedTree)RootedTree.Util.fromNewickString((String)IO.f2s((File)this.refTree)))) : UnrootedTree.fromRooted((RootedTree)RootedTree.Util.fromNewickString((String)IO.f2s((File)new File(f.getAbsolutePath().replaceAll("[.]msf$", ".newick")))));
            File computedRefTrees = new File(Execution.getFile((String)"computed-ref-trees"));
            for (int j = 0; j < this.repPerDataPt; ++j) {
                for (int i = 0; i < this.methods.size(); ++i) {
                    InferenceMethod m = this.methods.get(i);
                    double iterScale = this.iterScalings.get(i);
                    LogInfo.track((Object)("Current method:" + (Object)((Object)m) + " with iterScale=" + iterScale + " (i.e. " + iterScale * this.nThousandIters * 1000.0 + " iterations)"));
                    StatisticsMap.DescriptiveStatisticsMap stats = new StatisticsMap.DescriptiveStatisticsMap();
                    String treeNameCurrentRep = treeName;
                    LogInfo.track((Object)("Repeat " + (j + 1) + "/" + this.repPerDataPt));
                    long time = System.currentTimeMillis();
                    TreeDistancesProcessor processor = m.doIt(this, iterScale, goldut, treeNameCurrentRep);
                    time = System.currentTimeMillis() - time;
                    LogInfo.forceSilent = false;
                    UnrootedTree inferred = processor.getConsensus();
                    IO.writeToDisk((File)new File(this.output, "consensus_" + treeName.replaceAll("[.]msf$", ".newick")), (String)inferred.toNewick());
                    Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)this.data, (SequenceType)this.sequenceType);
                    CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites());
                    UnrootedTreeState ncs = UnrootedTreeState.initFastState((UnrootedTree)inferred, (Dataset)dataset, (CTMC)ctmc);
                    System.out.println(inferred);
                    out.println(CSV.body((Object[])new Object[]{m, iterScale, j, "ConsensusLogLL", ncs.logLikelihood(), treeName, time}));
                    double bestLogLL = processor.getBestLogLikelihood();
                    out.println(CSV.body((Object[])new Object[]{m, iterScale, j, "BestSampledLogLL", bestLogLL, treeName, time}));
                    if (goldut == null) {
                        LogInfo.logsForce((Object)("Computing gold tree using " + (Object)((Object)this.refMethod)));
                        goldut = this.refMethod.doIt(this, this.refIterScaling, goldut, treeName).getConsensus();
                        computedRefTrees.mkdir();
                        File current = new File(computedRefTrees, "computedRefTree_" + f.getName().replaceAll("[.]msf", "") + ".newick");
                        IO.writeToDisk((File)current, (String)goldut.toNewick());
                    }
                    for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
                        double value = tm.score(inferred, goldut);
                        stats.addValue((Object)tm.toString(), value);
                        out.println(CSV.body((Object[])new Object[]{m, iterScale, j, tm, value, treeName, time}));
                    }
                    LogInfo.track((Object)("Score for current block of repeats (Method=" + (Object)((Object)m) + ",IterScale=" + iterScale + ",TreeName=" + treeName + ")"));
                    for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
                        LogInfo.logsForce((Object)("Current " + tm + ":" + stats.median((Object)tm.toString())));
                    }
                    LogInfo.end_track();
                    out.flush();
                    LogInfo.end_track();
                    LogInfo.end_track();
                }
            }
            LogInfo.end_track();
        }
        out.close();
        this.logZout.close();
    }

    public static UnrootedTree initTree(Random rand, List<Taxon> leaves) {
        return UnrootedTree.fromRooted((RootedTree)TreeGenerators.sampleExpNonclock((Random)rand, leaves, (double)10.0));
    }

    public static <T> double dist(Counter<T> c1, Counter<T> c2) {
        double sum = 0.0;
        for (Object t : CollUtils.union((Set[])new Set[]{c1.keySet(), c2.keySet()})) {
            sum += Math.abs(c1.getCount(t) - c2.getCount(t));
        }
        return sum;
    }

    public static double dist(TreeDistancesProcessor p1, TreeDistancesProcessor p2) {
        return PGSExperiments.dist(p1.getUnrootedCladesPosterior(), p2.getUnrootedCladesPosterior());
    }

    @Override
    public void run() {
        if (this.methods.size() != this.iterScalings.size()) {
            throw new RuntimeException("Number of methods and scaling iters should match");
        }
        if (this.useDataGenerator) {
            LogInfo.logsForce((Object)"Generating data...");
            LogInfo.forceSilent = false;
            generator.run();
        } else {
            LogInfo.forceSilent = false;
            File dataDir = new File(Execution.getFile((String)this.dataDirName));
            LogInfo.logsForce((Object)("Copying data to " + dataDir));
            dataDir.mkdir();
            String str = IO.call((String)("/bin/cp " + this.dataFile + " " + dataDir + "/" + this.dataFile.getName()));
            LogInfo.logs((Object)str);
        }
        this.output = new File(Execution.getFile((String)"results"));
        this.output.mkdir();
        this.treeComparison();
    }

    public static enum InferenceMethod {
        SMC4K2P{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)instance.data, (SequenceType)instance.sequenceType);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc);
                PriorPriorKernel pk2 = new PriorPriorKernel(init);
                LazyParticleFilter lpf = new LazyParticleFilter((LazyParticleFilter.LazyParticleKernel)pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                if (instance.useTopologyProcessor) {
                    TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp, trTopo});
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                    String methodname = "SMC4K2P";
                    instance.logZout.println(CSV.body((Object[])new Object[]{treeName, methodname, zHat}));
                    instance.logZout.flush();
                } else {
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp});
                    String methodname = "SMC4K2P";
                    instance.logZout.println(CSV.body((Object[])new Object[]{treeName, methodname, zHat}));
                    instance.logZout.flush();
                }
                return tdp;
            }
        }
        ,
        SMC4K2PBF{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)instance.data, (SequenceType)instance.sequenceType);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites());
                PartialCoalescentState init0 = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc, (boolean)true);
                PartialCoalescentState4BackForwardKernel init = new PartialCoalescentState4BackForwardKernel(init0, init0, init0, null, 0.0, new int[]{-1, -1});
                BackForwardKernel pk2 = new BackForwardKernel(init);
                LazyParticleFilter lpf = new LazyParticleFilter((LazyParticleFilter.LazyParticleKernel)pk2, options);
                TreeProcessorBFState tdp = new TreeProcessorBFState();
                if (instance.useTopologyProcessor) {
                    TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp, trTopo});
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                    String methodname = "SMC4K2PBF";
                    instance.logZout.println(CSV.body((Object[])new Object[]{treeName, methodname, zHat}));
                    instance.logZout.flush();
                } else {
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp});
                    String methodname = "SMC4K2PBF";
                    instance.logZout.println(CSV.body((Object[])new Object[]{treeName, methodname, zHat}));
                    instance.logZout.flush();
                }
                return tdp;
            }
        }
        ,
        SMCNonClock4K2P{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)instance.data, (SequenceType)instance.sequenceType);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites(), (double)instance.csmc_trans2tranv);
                PartialCoalescentState init = PartialCoalescentState.initFastState((boolean)instance.resampleRoot, (Dataset)dataset, (CTMC)ctmc, (boolean)false);
                NCPriorPriorKernel pk2 = new NCPriorPriorKernel(init);
                LazyParticleFilter lpf = new LazyParticleFilter((LazyParticleFilter.LazyParticleKernel)pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp});
                LogInfo.logsForce((Object)("Norm:" + zHat));
                return tdp;
            }
        }
        ,
        SMC4GTRIGammaBF{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                int nCategories;
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double[] subsRates = PGSExperiments.generator.subsRates;
                double[] statFreqs = PGSExperiments.generator.stationaryDistribution;
                double alpha = PGSExperiments.generator.alpha;
                double pInv = PGSExperiments.generator.pInv;
                int dataRepeatN = nCategories = 4;
                if (pInv > 0.0) {
                    dataRepeatN = nCategories + 1;
                }
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType, (int)dataRepeatN);
                CTMC.GTRIGammaCTMC ctmc = new CTMC.GTRIGammaCTMC(statFreqs, subsRates, 4, dataset.nSites(), alpha, nCategories, pInv);
                PartialCoalescentState init0 = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc, (boolean)true);
                PartialCoalescentState4BackForwardKernel init = new PartialCoalescentState4BackForwardKernel(init0, init0, init0, null, 0.0, new int[]{-1, -1});
                BackForwardKernel pk2 = new BackForwardKernel(init);
                LazyParticleFilter lpf = new LazyParticleFilter((LazyParticleFilter.LazyParticleKernel)pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                if (instance.useTopologyProcessor) {
                    TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp, trTopo});
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                } else {
                    double d = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp});
                }
                return tdp;
            }
        }
        ,
        SMC4GTRIGamma{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                int nCategories;
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double[] subsRates = PGSExperiments.generator.subsRates;
                double[] statFreqs = PGSExperiments.generator.stationaryDistribution;
                double alpha = PGSExperiments.generator.alpha;
                double pInv = PGSExperiments.generator.pInv;
                int dataRepeatN = nCategories = 4;
                if (pInv > 0.0) {
                    dataRepeatN = nCategories + 1;
                }
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType, (int)dataRepeatN);
                CTMC.GTRIGammaCTMC ctmc = new CTMC.GTRIGammaCTMC(statFreqs, subsRates, 4, dataset.nSites(), alpha, nCategories, pInv);
                PartialCoalescentState init = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc, (boolean)true);
                PriorPriorKernel pk2 = new PriorPriorKernel(init);
                LazyParticleFilter lpf = new LazyParticleFilter((LazyParticleFilter.LazyParticleKernel)pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                if (instance.useTopologyProcessor) {
                    TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp, trTopo});
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                } else {
                    double d = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp});
                }
                return tdp;
            }
        }
        ,
        SMCNonClock4GTRIGamma{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                int nCategories;
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double[] subsRates = PGSExperiments.generator.subsRates;
                double[] statFreqs = PGSExperiments.generator.stationaryDistribution;
                double alpha = PGSExperiments.generator.alpha;
                double pInv = PGSExperiments.generator.pInv;
                int dataRepeatN = nCategories = 4;
                if (pInv > 0.0) {
                    dataRepeatN = nCategories + 1;
                }
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType, (int)dataRepeatN);
                CTMC.GTRIGammaCTMC ctmc = new CTMC.GTRIGammaCTMC(statFreqs, subsRates, 4, dataset.nSites(), alpha, nCategories, pInv);
                PartialCoalescentState init = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc, (boolean)false);
                NCPriorPriorKernel pk2 = new NCPriorPriorKernel(init);
                LazyParticleFilter lpf = new LazyParticleFilter((LazyParticleFilter.LazyParticleKernel)pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                if (instance.useTopologyProcessor) {
                    TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                    double zHat = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp, trTopo});
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                } else {
                    double d = lpf.sample(new ParticleFilter.ParticleProcessor[]{tdp});
                }
                return tdp;
            }
        }
        ,
        PGS4K2PBF{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = instance.nParticlesEachStep;
                options.nThreads = instance.nThreads;
                options.resampleLastRound = false;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double alpha = Sampling.nextDouble((Random)mainRand, (double)0.1, (double)0.9);
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                int nMCMC = (int)iterScale;
                boolean nPMMH = false;
                int nPGS = nMCMC - 0;
                String resultFolder = Execution.getFile((String)"results");
                File output = new File(resultFolder);
                LogInfo.logsForce((Object)(" # particles: " + options.nParticles + "; nMCMC:" + nMCMC));
                RootedTree initTree = null;
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                initTree = RandomRootedTrees.sampleCoalescent((Random)mainRand, (Collection)leaves, (double)10.0);
                options.nThreads = instance.nThreads;
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites(), (double)2.0);
                PartialCoalescentState init0 = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc, (boolean)true);
                PartialCoalescentState4BackForwardKernel init = new PartialCoalescentState4BackForwardKernel(init0, null, null, null, 0.0, new int[]{-1, -1});
                PGS4K2PBF pg = new PGS4K2PBF(dataset, options, tdp, instance.useTopologyProcessor, trTopo, initTree, false, instance.isPMCMC4clock, instance.sampleTreeEveryNIter, init, (CTMC)ctmc);
                pg.setSampleTrans2tranv(instance.sampleTrans2tranv);
                pg.setSaveTreesFromPMCMC(instance.saveTreesFromPMCMC);
                String allTreeFilename = "allTrees-PGS4K2PBF.trees";
                pg.setNameOfAllTrees(allTreeFilename);
                int i = 0;
                int nPGSburnin = (int)((double)nPGS * instance.burninPercent);
                while (i < nPGS) {
                    if (++i > nPGSburnin) {
                        pg.setProcessTree(true);
                    }
                    pg.next(mainRand);
                }
                if (instance.saveTreesFromPMCMC) {
                    IO.call((String)"bash -s", (String)("echo 'END;' >> " + allTreeFilename), (File)output);
                    String RcmdStr = instance.RcommandDir + "thetaTracePlot.R  \"resultFolder='" + resultFolder + "'\"";
                    String msg0 = IO.call((String)"bash -s", (String)RcmdStr, (File)output);
                    LogInfo.logs((Object)msg0);
                }
                if (instance.useTopologyProcessor) {
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                }
                return tdp;
            }
        }
        ,
        PGAS4K2PBF{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = instance.nParticlesEachStep;
                options.nThreads = instance.nThreads;
                options.resampleLastRound = false;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double alpha = Sampling.nextDouble((Random)mainRand, (double)0.1, (double)0.9);
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                int nMCMC = (int)iterScale;
                boolean nPMMH = false;
                int nPGS = nMCMC - 0;
                String resultFolder = Execution.getFile((String)"results");
                File output = new File(resultFolder);
                LogInfo.logsForce((Object)(" # particles: " + options.nParticles + "; nMCMC:" + nMCMC));
                RootedTree initTree = null;
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                initTree = RandomRootedTrees.sampleCoalescent((Random)mainRand, (Collection)leaves, (double)10.0);
                options.nThreads = instance.nThreads;
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites(), (double)2.0);
                PartialCoalescentState init0 = PartialCoalescentState.initFastState((Dataset)dataset, (CTMC)ctmc, (boolean)true);
                PartialCoalescentState4BackForwardKernel init = new PartialCoalescentState4BackForwardKernel(init0, null, null, null, 0.0, new int[]{-1, -1});
                PGAS4K2PBF pg = new PGAS4K2PBF(dataset, options, tdp, instance.useTopologyProcessor, trTopo, initTree, false, instance.isPMCMC4clock, instance.sampleTreeEveryNIter, init, (CTMC)ctmc);
                pg.setSampleTrans2tranv(instance.sampleTrans2tranv);
                pg.setSaveTreesFromPMCMC(instance.saveTreesFromPMCMC);
                String allTreeFilename = "allTrees-PGAS4K2PBF.trees";
                pg.setNameOfAllTrees(allTreeFilename);
                int i = 0;
                int nPGSburnin = (int)((double)nPGS * instance.burninPercent);
                while (i < nPGS) {
                    if (++i > nPGSburnin) {
                        pg.setProcessTree(true);
                    }
                    pg.next(mainRand);
                }
                if (instance.saveTreesFromPMCMC) {
                    IO.call((String)"bash -s", (String)("echo 'END;' >> " + allTreeFilename), (File)output);
                    String RcmdStr = instance.RcommandDir + "thetaTracePlot.R  \"resultFolder='" + resultFolder + "'\"";
                    String msg0 = IO.call((String)"bash -s", (String)RcmdStr, (File)output);
                    LogInfo.logs((Object)msg0);
                }
                if (instance.useTopologyProcessor) {
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                }
                return tdp;
            }
        }
        ,
        PGS4K2P{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = instance.nParticlesEachStep;
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double alpha = Sampling.nextDouble((Random)mainRand, (double)0.1, (double)0.9);
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                int nMCMC = (int)iterScale;
                boolean nPMMH = false;
                int nPGS = nMCMC - 0;
                String resultFolder = Execution.getFile((String)"results");
                File output = new File(resultFolder);
                LogInfo.logsForce((Object)(" # particles: " + options.nParticles + "; nMCMC:" + nMCMC));
                RootedTree initTree = null;
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                initTree = RandomRootedTrees.sampleCoalescent((Random)mainRand, (Collection)leaves, (double)10.0);
                options.nThreads = instance.nThreads;
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites(), (double)2.0);
                UnrootedTreeState ncs = UnrootedTreeState.initFastState((UnrootedTree)initTree.getUnrooted(), (Dataset)dataset, (CTMC)ctmc);
                PGS4K2P pg = new PGS4K2P(dataset, options, tdp, instance.useTopologyProcessor, trTopo, initTree, false, instance.isPMCMC4clock, instance.sampleTreeEveryNIter);
                pg.setSampleTrans2tranv(instance.sampleTrans2tranv);
                pg.setSaveTreesFromPMCMC(instance.saveTreesFromPMCMC);
                String allTreeFilename = "allTrees-PGS4K2P.trees";
                pg.setNameOfAllTrees(allTreeFilename);
                int i = 0;
                int nPGSburnin = (int)((double)nPGS * instance.burninPercent);
                while (i < nPGS) {
                    if (++i > nPGSburnin) {
                        pg.setProcessTree(true);
                    }
                    pg.next(mainRand);
                }
                if (instance.saveTreesFromPMCMC) {
                    IO.call((String)"bash -s", (String)("echo 'END;' >> " + allTreeFilename), (File)output);
                    String RcmdStr = instance.RcommandDir + "thetaTracePlot.R  \"resultFolder='" + resultFolder + "'\"";
                    String msg0 = IO.call((String)"bash -s", (String)RcmdStr, (File)output);
                    LogInfo.logs((Object)msg0);
                }
                if (instance.useTopologyProcessor) {
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                }
                return tdp;
            }
        }
        ,
        MB{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                MrBayes mb = MrBayes.instance;
                mb.nChains = 1;
                mb.seed = mainRand.nextInt();
                mb.nMCMCIters = (int)(iterScale * instance.nThousandIters * 1000.0);
                mb.setToK2P = false;
                mb.set2nst = true;
                mb.treePrior = "unconstrained:exp(10.0)";
                mb.setFixCoalescentPr = true;
                mb.st = SequenceType.DNA;
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                RootedTree initTree = RandomRootedTrees.sampleCoalescent((Random)mainRand, (Collection)leaves, (double)10.0);
                String outName = "startTree.newick";
                File file = new File(instance.output, outName);
                String cmdStr = "cat " + outName + "  | sed 's/internal_[0-9]*//g' > start-tree.newick";
                IO.call((String)"bash -s", (String)cmdStr, (File)instance.output);
                mb.computeSamples(MSAParser.parseMSA((File)instance.data), instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                mb.processMrBayesTrees((RootedTree.RootedTreeProcessor)tdp, 1);
                mb.seed = mainRand.nextInt();
                mb.nMCMCIters = (int)(iterScale * instance.nThousandIters * 1000.0);
                instance.logZout.flush();
                return tdp;
            }
        }
        ,
        IPGS4K2P{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = instance.nParticlesEachStep;
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double alpha = Sampling.nextDouble((Random)mainRand, (double)0.1, (double)0.9);
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                int nMCMC = (int)iterScale;
                boolean nPMMH = false;
                int nPGS = nMCMC - 0;
                String resultFolder = Execution.getFile((String)"results");
                File output = new File(resultFolder);
                LogInfo.logsForce((Object)(" # particles: " + options.nParticles + "; nMCMC:" + nMCMC));
                RootedTree initTree = null;
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                initTree = RandomRootedTrees.sampleCoalescent((Random)mainRand, (Collection)leaves, (double)10.0);
                options.nThreads = instance.nThreads;
                InteractingParticleGibbs4K2P pg = new InteractingParticleGibbs4K2P(dataset, options, tdp, instance.useTopologyProcessor, trTopo, initTree, false, instance.isPMCMC4clock, instance.sampleTreeEveryNIter, instance.nCSMC, instance.nUCSMC);
                pg.setSampleTrans2tranv(instance.sampleTrans2tranv);
                pg.setSaveTreesFromPMCMC(instance.saveTreesFromPMCMC);
                String allTreeFilename = "allTrees-PGS4K2P.trees";
                pg.setNameOfAllTrees(allTreeFilename);
                int i = 0;
                int nPGSburnin = (int)((double)nPGS * instance.burninPercent);
                while (i < nPGS) {
                    if (++i > nPGSburnin) {
                        pg.setProcessTree(true);
                    }
                    pg.next(mainRand);
                }
                if (instance.saveTreesFromPMCMC) {
                    IO.call((String)"bash -s", (String)("echo 'END;' >> " + allTreeFilename), (File)output);
                    String RcmdStr = instance.RcommandDir + "thetaTracePlot.R  \"resultFolder='" + resultFolder + "'\"";
                    String msg0 = IO.call((String)"bash -s", (String)RcmdStr, (File)output);
                    LogInfo.logs((Object)msg0);
                }
                if (instance.useTopologyProcessor) {
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                }
                return tdp;
            }
        }
        ,
        IPGS4K2PBF{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = instance.nParticlesEachStep;
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = mainRand;
                options.verbose = instance.verbose;
                double alpha = Sampling.nextDouble((Random)mainRand, (double)0.1, (double)0.9);
                MSAPoset align = MSAPoset.parseAlnOrMsfFormats((File)instance.data);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((MSAPoset)align, (SequenceType)instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                TreeTopologyProcessor trTopo = new TreeTopologyProcessor();
                int nMCMC = (int)iterScale;
                boolean nPMMH = false;
                int nPGS = nMCMC - 0;
                String resultFolder = Execution.getFile((String)"results");
                File output = new File(resultFolder);
                LogInfo.logsForce((Object)(" # particles: " + options.nParticles + "; nMCMC:" + nMCMC));
                RootedTree initTree = null;
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                initTree = RandomRootedTrees.sampleCoalescent((Random)mainRand, (Collection)leaves, (double)10.0);
                options.nThreads = instance.nThreads;
                InteractingParticleGibbs4K2PBF pg = new InteractingParticleGibbs4K2PBF(dataset, options, tdp, instance.useTopologyProcessor, trTopo, initTree, false, instance.isPMCMC4clock, instance.sampleTreeEveryNIter, instance.nCSMC, instance.nUCSMC);
                pg.setSampleTrans2tranv(instance.sampleTrans2tranv);
                pg.setSaveTreesFromPMCMC(instance.saveTreesFromPMCMC);
                String allTreeFilename = "allTrees-PGS4K2P.trees";
                pg.setNameOfAllTrees(allTreeFilename);
                int i = 0;
                int nPGSburnin = (int)((double)nPGS * instance.burninPercent);
                while (i < nPGS) {
                    if (++i > nPGSburnin) {
                        pg.setProcessTree(true);
                    }
                    pg.next(mainRand);
                }
                if (instance.saveTreesFromPMCMC) {
                    IO.call((String)"bash -s", (String)("echo 'END;' >> " + allTreeFilename), (File)output);
                    String RcmdStr = instance.RcommandDir + "thetaTracePlot.R  \"resultFolder='" + resultFolder + "'\"";
                    String msg0 = IO.call((String)"bash -s", (String)RcmdStr, (File)output);
                    LogInfo.logs((Object)msg0);
                }
                if (instance.useTopologyProcessor) {
                    Counter urtCounter = trTopo.getUrtCounter();
                    LogInfo.logsForce((Object)("\n Number of unique unrooted trees: " + urtCounter.keySet().size()));
                    for (UnrootedTree urt : urtCounter.keySet()) {
                        LogInfo.logsForce((Object)urt);
                        LogInfo.logsForce((Object)urtCounter.getCount((Object)urt));
                    }
                }
                return tdp;
            }
        }
        ,
        PG{

            @Override
            public TreeDistancesProcessor doIt(PGSExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                ParticleFilter pc = new ParticleFilter();
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = false;
                pc.rand = mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)instance.data, (SequenceType)instance.sequenceType);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState((boolean)instance.resampleRoot, (Dataset)dataset, (CTMC)ctmc, (boolean)false);
                NCPriorPriorKernel ppk = new NCPriorPriorKernel(init);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                double requested = iterScale * instance.nThousandIters * 1000.0;
                pc.N = instance.nParticlesEachStep;
                PG pg = new PG(pc, ppk, tdp, init);
                int nMCMC = 1 + (int)Math.pow(requested, 1.0 - instance.pmcmcSMCExpMix);
                System.out.println("pc.N is " + pc.N + "; nMCMC is " + nMCMC);
                for (int i = 0; i < nMCMC; ++i) {
                    System.out.println("Iteration " + i);
                    pg.next(mainRand);
                }
                return tdp;
            }
        };


        abstract TreeDistancesProcessor doIt(PGSExperiments var1, double var2, UnrootedTree var4, String var5);
    }
}

